/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import android.content.Context;
import java.net.URISyntaxException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.InfoCounts;
import org.mozilla.gecko.sync.JSONRecordFetcher;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.repositories.ConstrainedServer11Repository;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.Server11RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;

public class SafeConstrainedServer11Repository
extends ConstrainedServer11Repository {
    private JSONRecordFetcher countFetcher;

    public SafeConstrainedServer11Repository(String string2, String string3, AuthHeaderProvider authHeaderProvider, InfoCollections infoCollections, long l, String string4, JSONRecordFetcher jSONRecordFetcher) throws URISyntaxException {
        super(string2, string3, authHeaderProvider, infoCollections, l, string4);
        if (jSONRecordFetcher == null) {
            throw new IllegalArgumentException("countFetcher must not be null");
        }
        this.countFetcher = jSONRecordFetcher;
    }

    @Override
    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        repositorySessionCreationDelegate.onSessionCreated(new CountCheckingServer11RepositorySession(this, this.getDefaultFetchLimit()));
    }

    public class CountCheckingServer11RepositorySession
    extends Server11RepositorySession {
        private static final String LOG_TAG = "CountCheckingServer11RepositorySession";
        private long fetchLimit;

        public CountCheckingServer11RepositorySession(Repository repository, long l) {
            super(repository);
            this.fetchLimit = l;
        }

        @Override
        public boolean shouldSkip() {
            long l = this.getLastSyncTimestamp();
            if (l > 0L) {
                Logger.info(LOG_TAG, "Collection " + SafeConstrainedServer11Repository.this.collection + " has already had a first sync: " + "timestamp is " + l + "; " + "ignoring any updated counts and syncing as usual.");
            } else {
                InfoCounts infoCounts;
                Logger.info(LOG_TAG, "Collection " + SafeConstrainedServer11Repository.this.collection + " is starting a first sync; checking counts.");
                try {
                    infoCounts = new InfoCounts(SafeConstrainedServer11Repository.this.countFetcher.fetchBlocking());
                }
                catch (Exception exception) {
                    Logger.warn(LOG_TAG, "Skipping " + SafeConstrainedServer11Repository.this.collection + " until we can fetch counts.", exception);
                    return true;
                }
                Integer n = infoCounts.getCount(SafeConstrainedServer11Repository.this.collection);
                if (n == null) {
                    Logger.info(LOG_TAG, "Fetched counts does not include collection " + SafeConstrainedServer11Repository.this.collection + "; syncing as usual.");
                    return false;
                }
                Logger.info(LOG_TAG, "First sync for " + SafeConstrainedServer11Repository.this.collection + ": " + n + " items.");
                if ((long)n.intValue() > this.fetchLimit) {
                    Logger.warn(LOG_TAG, "Too many items to sync safely. Skipping.");
                    return true;
                }
            }
            return super.shouldSkip();
        }
    }
}

