/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.utils;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.HttpClient;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static void closeQuietly(HttpResponse httpResponse) {
        HttpEntity httpEntity;
        if (httpResponse != null && (httpEntity = httpResponse.getEntity()) != null) {
            try {
                EntityUtils.consume(httpEntity);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeQuietly(CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null) {
            try {
                try {
                    EntityUtils.consume(closeableHttpResponse.getEntity());
                }
                finally {
                    closeableHttpResponse.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(HttpClient httpClient) {
        if (httpClient != null && httpClient instanceof Closeable) {
            try {
                ((Closeable)((Object)httpClient)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

