/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.entity.mime.content;

import ch.boye.httpclientandroidlib.entity.ContentType;
import ch.boye.httpclientandroidlib.entity.mime.content.ContentBody;
import ch.boye.httpclientandroidlib.util.Args;
import java.nio.charset.Charset;

public abstract class AbstractContentBody
implements ContentBody {
    private final ContentType contentType;

    public AbstractContentBody(ContentType contentType) {
        Args.notNull(contentType, "Content type");
        this.contentType = contentType;
    }

    @Deprecated
    public AbstractContentBody(String string) {
        this(ContentType.parse(string));
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getMimeType() {
        return this.contentType.getMimeType();
    }

    @Override
    public String getMediaType() {
        String string = this.contentType.getMimeType();
        int n = string.indexOf(47);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    @Override
    public String getSubType() {
        String string = this.contentType.getMimeType();
        int n = string.indexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return null;
    }

    @Override
    public String getCharset() {
        Charset charset = this.contentType.getCharset();
        return charset != null ? charset.name() : null;
    }
}

