/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.entity.mime.content;

import ch.boye.httpclientandroidlib.entity.ContentType;
import ch.boye.httpclientandroidlib.entity.mime.content.AbstractContentBody;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;

    @Deprecated
    public InputStreamBody(InputStream inputStream, String string, String string2) {
        this(inputStream, ContentType.create(string), string2);
    }

    public InputStreamBody(InputStream inputStream, String string) {
        this(inputStream, ContentType.DEFAULT_BINARY, string);
    }

    public InputStreamBody(InputStream inputStream, ContentType contentType, String string) {
        super(contentType);
        Args.notNull(inputStream, "Input stream");
        this.in = inputStream;
        this.filename = string;
    }

    public InputStreamBody(InputStream inputStream, ContentType contentType) {
        this(inputStream, contentType, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = this.in.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

