/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheStorage;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheUpdateCallback;
import ch.boye.httpclientandroidlib.client.cache.Resource;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheConfig;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheMap;
import ch.boye.httpclientandroidlib.impl.client.cache.ResourceReference;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class ManagedHttpCacheStorage
implements HttpCacheStorage,
Closeable {
    private final CacheMap entries;
    private final ReferenceQueue<HttpCacheEntry> morque;
    private final Set<ResourceReference> resources;
    private final AtomicBoolean active;

    public ManagedHttpCacheStorage(CacheConfig cacheConfig) {
        this.entries = new CacheMap(cacheConfig.getMaxCacheEntries());
        this.morque = new ReferenceQueue();
        this.resources = new HashSet<ResourceReference>();
        this.active = new AtomicBoolean(true);
    }

    private void ensureValidState() throws IllegalStateException {
        if (!this.active.get()) {
            throw new IllegalStateException("Cache has been shut down");
        }
    }

    private void keepResourceReference(HttpCacheEntry httpCacheEntry) {
        Resource resource = httpCacheEntry.getResource();
        if (resource != null) {
            ResourceReference resourceReference = new ResourceReference(httpCacheEntry, this.morque);
            this.resources.add(resourceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(String string, HttpCacheEntry httpCacheEntry) throws IOException {
        Args.notNull(string, "URL");
        Args.notNull(httpCacheEntry, "Cache entry");
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            this.entries.put(string, httpCacheEntry);
            this.keepResourceReference(httpCacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpCacheEntry getEntry(String string) throws IOException {
        Args.notNull(string, "URL");
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            return (HttpCacheEntry)this.entries.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(String string) throws IOException {
        Args.notNull(string, "URL");
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            this.entries.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntry(String string, HttpCacheUpdateCallback httpCacheUpdateCallback) throws IOException {
        Args.notNull(string, "URL");
        Args.notNull(httpCacheUpdateCallback, "Callback");
        this.ensureValidState();
        ManagedHttpCacheStorage managedHttpCacheStorage = this;
        synchronized (managedHttpCacheStorage) {
            HttpCacheEntry httpCacheEntry = (HttpCacheEntry)this.entries.get(string);
            HttpCacheEntry httpCacheEntry2 = httpCacheUpdateCallback.update(httpCacheEntry);
            this.entries.put(string, httpCacheEntry2);
            if (httpCacheEntry != httpCacheEntry2) {
                this.keepResourceReference(httpCacheEntry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanResources() {
        if (this.active.get()) {
            ResourceReference resourceReference;
            while ((resourceReference = (ResourceReference)this.morque.poll()) != null) {
                ManagedHttpCacheStorage managedHttpCacheStorage = this;
                synchronized (managedHttpCacheStorage) {
                    this.resources.remove(resourceReference);
                }
                resourceReference.getResource().dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.active.compareAndSet(true, false)) {
            ManagedHttpCacheStorage managedHttpCacheStorage = this;
            synchronized (managedHttpCacheStorage) {
                this.entries.clear();
                for (ResourceReference resourceReference : this.resources) {
                    resourceReference.getResource().dispose();
                }
                this.resources.clear();
                while (this.morque.poll() != null) {
                }
            }
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

