/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.client.utils.DateUtils;
import ch.boye.httpclientandroidlib.impl.client.cache.IOUtils;
import ch.boye.httpclientandroidlib.impl.client.cache.WarningValue;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

@Immutable
class ResponseProtocolCompliance {
    private static final String UNEXPECTED_100_CONTINUE = "The incoming request did not contain a 100-continue header, but the response was a Status 100, continue.";
    private static final String UNEXPECTED_PARTIAL_CONTENT = "partial content was returned for a request that did not ask for it";

    ResponseProtocolCompliance() {
    }

    public void ensureProtocolCompliance(HttpRequestWrapper httpRequestWrapper, HttpResponse httpResponse) throws IOException {
        if (this.backendResponseMustNotHaveBody(httpRequestWrapper, httpResponse)) {
            this.consumeBody(httpResponse);
            httpResponse.setEntity(null);
        }
        this.requestDidNotExpect100ContinueButResponseIsOne(httpRequestWrapper, httpResponse);
        this.transferEncodingIsNotReturnedTo1_0Client(httpRequestWrapper, httpResponse);
        this.ensurePartialContentIsNotSentToAClientThatDidNotRequestIt(httpRequestWrapper, httpResponse);
        this.ensure200ForOPTIONSRequestWithNoBodyHasContentLengthZero(httpRequestWrapper, httpResponse);
        this.ensure206ContainsDateHeader(httpResponse);
        this.ensure304DoesNotContainExtraEntityHeaders(httpResponse);
        this.identityIsNotUsedInContentEncoding(httpResponse);
        this.warningsWithNonMatchingWarnDatesAreRemoved(httpResponse);
    }

    private void consumeBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            IOUtils.consume(httpEntity);
        }
    }

    private void warningsWithNonMatchingWarnDatesAreRemoved(HttpResponse httpResponse) {
        Date date = DateUtils.parseDate(httpResponse.getFirstHeader("Date").getValue());
        if (date == null) {
            return;
        }
        Header[] headerArray = httpResponse.getHeaders("Warning");
        if (headerArray == null || headerArray.length == 0) {
            return;
        }
        ArrayList<BasicHeader> arrayList = new ArrayList<BasicHeader>();
        boolean bl = false;
        for (Header header : headerArray) {
            for (WarningValue warningValue : WarningValue.getWarningValues(header)) {
                Date date2 = warningValue.getWarnDate();
                if (date2 == null || date2.equals(date)) {
                    arrayList.add(new BasicHeader("Warning", warningValue.toString()));
                    continue;
                }
                bl = true;
            }
        }
        if (bl) {
            httpResponse.removeHeaders("Warning");
            for (Header header : arrayList) {
                httpResponse.addHeader(header);
            }
        }
    }

    private void identityIsNotUsedInContentEncoding(HttpResponse httpResponse) {
        Header[] headerArray = httpResponse.getHeaders("Content-Encoding");
        if (headerArray == null || headerArray.length == 0) {
            return;
        }
        ArrayList<BasicHeader> arrayList = new ArrayList<BasicHeader>();
        boolean bl = false;
        for (Header header : headerArray) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = true;
            for (HeaderElement headerElement : header.getElements()) {
                if ("identity".equalsIgnoreCase(headerElement.getName())) {
                    bl = true;
                    continue;
                }
                if (!bl2) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(headerElement.toString());
                bl2 = false;
            }
            String object = stringBuilder.toString();
            if ("".equals(object)) continue;
            arrayList.add(new BasicHeader("Content-Encoding", object));
        }
        if (!bl) {
            return;
        }
        httpResponse.removeHeaders("Content-Encoding");
        for (Header header : arrayList) {
            httpResponse.addHeader(header);
        }
    }

    private void ensure206ContainsDateHeader(HttpResponse httpResponse) {
        if (httpResponse.getFirstHeader("Date") == null) {
            httpResponse.addHeader("Date", DateUtils.formatDate(new Date()));
        }
    }

    private void ensurePartialContentIsNotSentToAClientThatDidNotRequestIt(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        if (httpRequest.getFirstHeader("Range") != null || httpResponse.getStatusLine().getStatusCode() != 206) {
            return;
        }
        this.consumeBody(httpResponse);
        throw new ClientProtocolException(UNEXPECTED_PARTIAL_CONTENT);
    }

    private void ensure200ForOPTIONSRequestWithNoBodyHasContentLengthZero(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (!httpRequest.getRequestLine().getMethod().equalsIgnoreCase("OPTIONS")) {
            return;
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            return;
        }
        if (httpResponse.getFirstHeader("Content-Length") == null) {
            httpResponse.addHeader("Content-Length", "0");
        }
    }

    private void ensure304DoesNotContainExtraEntityHeaders(HttpResponse httpResponse) {
        String[] stringArray = new String[]{"Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-MD5", "Content-Range", "Content-Type", "Last-Modified"};
        if (httpResponse.getStatusLine().getStatusCode() == 304) {
            for (String string : stringArray) {
                httpResponse.removeHeaders(string);
            }
        }
    }

    private boolean backendResponseMustNotHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        return "HEAD".equals(httpRequest.getRequestLine().getMethod()) || httpResponse.getStatusLine().getStatusCode() == 204 || httpResponse.getStatusLine().getStatusCode() == 205 || httpResponse.getStatusLine().getStatusCode() == 304;
    }

    private void requestDidNotExpect100ContinueButResponseIsOne(HttpRequestWrapper httpRequestWrapper, HttpResponse httpResponse) throws IOException {
        if (httpResponse.getStatusLine().getStatusCode() != 100) {
            return;
        }
        HttpRequest httpRequest = httpRequestWrapper.getOriginal();
        if (httpRequest instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)httpRequest).expectContinue()) {
            return;
        }
        this.consumeBody(httpResponse);
        throw new ClientProtocolException(UNEXPECTED_100_CONTINUE);
    }

    private void transferEncodingIsNotReturnedTo1_0Client(HttpRequestWrapper httpRequestWrapper, HttpResponse httpResponse) {
        HttpRequest httpRequest = httpRequestWrapper.getOriginal();
        if (httpRequest.getProtocolVersion().compareToVersion(HttpVersion.HTTP_1_1) >= 0) {
            return;
        }
        this.removeResponseTransferEncoding(httpResponse);
    }

    private void removeResponseTransferEncoding(HttpResponse httpResponse) {
        httpResponse.removeHeaders("TE");
        httpResponse.removeHeaders("Transfer-Encoding");
    }
}

