/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@Immutable
public class Wire {
    public HttpClientAndroidLog log;
    private final String id;

    public Wire(HttpClientAndroidLog httpClientAndroidLog, String string) {
        this.log = httpClientAndroidLog;
        this.id = string;
    }

    public Wire(HttpClientAndroidLog httpClientAndroidLog) {
        this(httpClientAndroidLog, "");
    }

    private void wire(String string, InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read()) != -1) {
            if (n == 13) {
                stringBuilder.append("[\\r]");
                continue;
            }
            if (n == 10) {
                stringBuilder.append("[\\n]\"");
                stringBuilder.insert(0, "\"");
                stringBuilder.insert(0, string);
                this.log.debug(this.id + " " + stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            if (n < 32 || n > 127) {
                stringBuilder.append("[0x");
                stringBuilder.append(Integer.toHexString(n));
                stringBuilder.append("]");
                continue;
            }
            stringBuilder.append((char)n);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\"');
            stringBuilder.insert(0, '\"');
            stringBuilder.insert(0, string);
            this.log.debug(this.id + " " + stringBuilder.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream inputStream) throws IOException {
        Args.notNull(inputStream, "Output");
        this.wire(">> ", inputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        Args.notNull(inputStream, "Input");
        this.wire("<< ", inputStream);
    }

    public void output(byte[] byArray, int n, int n2) throws IOException {
        Args.notNull(byArray, "Output");
        this.wire(">> ", new ByteArrayInputStream(byArray, n, n2));
    }

    public void input(byte[] byArray, int n, int n2) throws IOException {
        Args.notNull(byArray, "Input");
        this.wire("<< ", new ByteArrayInputStream(byArray, n, n2));
    }

    public void output(byte[] byArray) throws IOException {
        Args.notNull(byArray, "Output");
        this.wire(">> ", new ByteArrayInputStream(byArray));
    }

    public void input(byte[] byArray) throws IOException {
        Args.notNull(byArray, "Input");
        this.wire("<< ", new ByteArrayInputStream(byArray));
    }

    public void output(int n) throws IOException {
        this.output(new byte[]{(byte)n});
    }

    public void input(int n) throws IOException {
        this.input(new byte[]{(byte)n});
    }

    public void output(String string) throws IOException {
        Args.notNull(string, "Output");
        this.output(string.getBytes());
    }

    public void input(String string) throws IOException {
        Args.notNull(string, "Input");
        this.input(string.getBytes());
    }
}

