/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.cookie;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.cookie.ClientCookie;
import ch.boye.httpclientandroidlib.cookie.Cookie;
import ch.boye.httpclientandroidlib.cookie.CookieAttributeHandler;
import ch.boye.httpclientandroidlib.cookie.CookieOrigin;
import ch.boye.httpclientandroidlib.cookie.MalformedCookieException;
import ch.boye.httpclientandroidlib.impl.cookie.BasicClientCookie2;
import ch.boye.httpclientandroidlib.impl.cookie.RFC2109Spec;
import ch.boye.httpclientandroidlib.impl.cookie.RFC2965CommentUrlAttributeHandler;
import ch.boye.httpclientandroidlib.impl.cookie.RFC2965DiscardAttributeHandler;
import ch.boye.httpclientandroidlib.impl.cookie.RFC2965DomainAttributeHandler;
import ch.boye.httpclientandroidlib.impl.cookie.RFC2965PortAttributeHandler;
import ch.boye.httpclientandroidlib.impl.cookie.RFC2965VersionAttributeHandler;
import ch.boye.httpclientandroidlib.message.BufferedHeader;
import ch.boye.httpclientandroidlib.util.Args;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@NotThreadSafe
public class RFC2965Spec
extends RFC2109Spec {
    public RFC2965Spec() {
        this(null, false);
    }

    public RFC2965Spec(String[] stringArray, boolean bl) {
        super(stringArray, bl);
        this.registerAttribHandler("domain", new RFC2965DomainAttributeHandler());
        this.registerAttribHandler("port", new RFC2965PortAttributeHandler());
        this.registerAttribHandler("commenturl", new RFC2965CommentUrlAttributeHandler());
        this.registerAttribHandler("discard", new RFC2965DiscardAttributeHandler());
        this.registerAttribHandler("version", new RFC2965VersionAttributeHandler());
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(cookieOrigin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie2")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] headerElementArray = header.getElements();
        return this.createCookies(headerElementArray, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    protected List<Cookie> parse(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return this.createCookies(headerElementArray, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    private List<Cookie> createCookies(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(headerElementArray.length);
        for (HeaderElement headerElement : headerElementArray) {
            String string = headerElement.getName();
            String string2 = headerElement.getValue();
            if (string == null || string.length() == 0) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie2 basicClientCookie2 = new BasicClientCookie2(string, string2);
            basicClientCookie2.setPath(RFC2965Spec.getDefaultPath(cookieOrigin));
            basicClientCookie2.setDomain(RFC2965Spec.getDefaultDomain(cookieOrigin));
            basicClientCookie2.setPorts(new int[]{cookieOrigin.getPort()});
            NameValuePair[] nameValuePairArray = headerElement.getParameters();
            HashMap<String, NameValuePair> hashMap = new HashMap<String, NameValuePair>(nameValuePairArray.length);
            for (int i = nameValuePairArray.length - 1; i >= 0; --i) {
                NameValuePair nameValuePair = nameValuePairArray[i];
                hashMap.put(nameValuePair.getName().toLowerCase(Locale.ENGLISH), nameValuePair);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                NameValuePair nameValuePair = (NameValuePair)entry.getValue();
                String string3 = nameValuePair.getName().toLowerCase(Locale.ENGLISH);
                basicClientCookie2.setAttribute(string3, nameValuePair.getValue());
                CookieAttributeHandler cookieAttributeHandler = this.findAttribHandler(string3);
                if (cookieAttributeHandler == null) continue;
                cookieAttributeHandler.parse(basicClientCookie2, nameValuePair.getValue());
            }
            arrayList.add(basicClientCookie2);
        }
        return arrayList;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        super.validate(cookie, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        return super.match(cookie, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n) {
        String string;
        super.formatCookieAsVer(charArrayBuffer, cookie, n);
        if (cookie instanceof ClientCookie && (string = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] nArray;
            charArrayBuffer.append("; $Port");
            charArrayBuffer.append("=\"");
            if (string.trim().length() > 0 && (nArray = cookie.getPorts()) != null) {
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        charArrayBuffer.append(",");
                    }
                    charArrayBuffer.append(Integer.toString(nArray[i]));
                }
            }
            charArrayBuffer.append("\"");
        }
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin cookieOrigin) {
        String string = cookieOrigin.getHost();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != ':') continue;
            bl = false;
            break;
        }
        if (bl) {
            string = string + ".local";
            return new CookieOrigin(string, cookieOrigin.getPort(), cookieOrigin.getPath(), cookieOrigin.isSecure());
        }
        return cookieOrigin;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(40);
        charArrayBuffer.append("Cookie2");
        charArrayBuffer.append(": ");
        charArrayBuffer.append("$Version=");
        charArrayBuffer.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public String toString() {
        return "rfc2965";
    }
}

