/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.execchain;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.NoHttpResponseException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.HttpRequestRetryHandler;
import ch.boye.httpclientandroidlib.client.NonRepeatableRequestException;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpExecutionAware;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.execchain.ClientExecChain;
import ch.boye.httpclientandroidlib.impl.execchain.RequestEntityProxy;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;

@Immutable
public class RetryExec
implements ClientExecChain {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain clientExecChain, HttpRequestRetryHandler httpRequestRetryHandler) {
        Args.notNull(clientExecChain, "HTTP request executor");
        Args.notNull(httpRequestRetryHandler, "HTTP request retry handler");
        this.requestExecutor = clientExecChain;
        this.retryHandler = httpRequestRetryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            }
            catch (IOException iOException) {
                if (httpExecutionAware != null && httpExecutionAware.isAborted()) {
                    this.log.debug("Request has been aborted");
                    throw iOException;
                }
                if (this.retryHandler.retryRequest(iOException, n, httpClientContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("I/O exception (" + iOException.getClass().getName() + ") caught when processing request to " + httpRoute + ": " + iOException.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(iOException.getMessage(), iOException);
                    }
                    if (!RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                        this.log.debug("Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", iOException);
                    }
                    httpRequestWrapper.setHeaders(headerArray);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Retrying request to " + httpRoute);
                    }
                } else {
                    if (iOException instanceof NoHttpResponseException) {
                        NoHttpResponseException noHttpResponseException = new NoHttpResponseException(httpRoute.getTargetHost().toHostString() + " failed to respond");
                        noHttpResponseException.setStackTrace(iOException.getStackTrace());
                        throw noHttpResponseException;
                    }
                    throw iOException;
                }
                ++n;
                continue;
            }
            break;
        }
    }
}

