/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.util.Log;
import com.nineoldandroids.animation.FloatEvaluator;
import com.nineoldandroids.animation.FloatKeyframeSet;
import com.nineoldandroids.animation.IntEvaluator;
import com.nineoldandroids.animation.IntKeyframeSet;
import com.nineoldandroids.animation.Keyframe;
import com.nineoldandroids.animation.KeyframeSet;
import com.nineoldandroids.animation.TypeEvaluator;
import com.nineoldandroids.util.FloatProperty;
import com.nineoldandroids.util.IntProperty;
import com.nineoldandroids.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertyValuesHolder
implements Cloneable {
    String mPropertyName;
    protected Property mProperty;
    Method mSetter = null;
    private Method mGetter = null;
    Class mValueType;
    KeyframeSet mKeyframeSet = null;
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private static Class[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    private static Class[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    private static Class[] DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
    private static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap = new HashMap();
    private static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap = new HashMap();
    final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    final Object[] mTmpValueArray = new Object[1];
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;

    private PropertyValuesHolder(String string) {
        this.mPropertyName = string;
    }

    private PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    public static PropertyValuesHolder ofInt(String string, int ... nArray) {
        return new IntPropertyValuesHolder(string, nArray);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... nArray) {
        return new IntPropertyValuesHolder(property, nArray);
    }

    public static PropertyValuesHolder ofFloat(String string, float ... fArray) {
        return new FloatPropertyValuesHolder(string, fArray);
    }

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... fArray) {
        return new FloatPropertyValuesHolder(property, fArray);
    }

    public static PropertyValuesHolder ofObject(String string, TypeEvaluator typeEvaluator, Object ... objectArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string);
        propertyValuesHolder.setObjectValues(objectArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    public static <V> PropertyValuesHolder ofObject(Property property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.setObjectValues(VArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    public static PropertyValuesHolder ofKeyframe(String string, Keyframe ... keyframeArray) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(string, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(string, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string);
        propertyValuesHolder.mKeyframeSet = keyframeSet;
        propertyValuesHolder.mValueType = keyframeArray[0].getType();
        return propertyValuesHolder;
    }

    public static PropertyValuesHolder ofKeyframe(Property property, Keyframe ... keyframeArray) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(property, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(property, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.mKeyframeSet = keyframeSet;
        propertyValuesHolder.mValueType = keyframeArray[0].getType();
        return propertyValuesHolder;
    }

    public void setIntValues(int ... nArray) {
        this.mValueType = Integer.TYPE;
        this.mKeyframeSet = KeyframeSet.ofInt(nArray);
    }

    public void setFloatValues(float ... fArray) {
        this.mValueType = Float.TYPE;
        this.mKeyframeSet = KeyframeSet.ofFloat(fArray);
    }

    public void setKeyframes(Keyframe ... keyframeArray) {
        int n = keyframeArray.length;
        Keyframe[] keyframeArray2 = new Keyframe[Math.max(n, 2)];
        this.mValueType = keyframeArray[0].getType();
        for (int i = 0; i < n; ++i) {
            keyframeArray2[i] = keyframeArray[i];
        }
        this.mKeyframeSet = new KeyframeSet(keyframeArray2);
    }

    public void setObjectValues(Object ... objectArray) {
        this.mValueType = objectArray[0].getClass();
        this.mKeyframeSet = KeyframeSet.ofObject(objectArray);
    }

    private Method getPropertyFunction(Class clazz, String string, Class clazz2) {
        Method method = null;
        String string2 = PropertyValuesHolder.getMethodName(string, this.mPropertyName);
        Class[] classArray = null;
        if (clazz2 == null) {
            try {
                method = clazz.getMethod(string2, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getDeclaredMethod(string2, classArray);
                    method.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Log.e((String)"PropertyValuesHolder", (String)("Couldn't find no-arg method for property " + this.mPropertyName + ": " + noSuchMethodException));
                }
            }
        } else {
            classArray = new Class[1];
            Class[] classArray2 = this.mValueType.equals(Float.class) ? FLOAT_VARIANTS : (this.mValueType.equals(Integer.class) ? INTEGER_VARIANTS : (this.mValueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{this.mValueType}));
            Class[] classArray3 = classArray2;
            int n = classArray3.length;
            for (int i = 0; i < n; ++i) {
                Class clazz3;
                classArray[0] = clazz3 = classArray3[i];
                try {
                    method = clazz.getMethod(string2, classArray);
                    this.mValueType = clazz3;
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getDeclaredMethod(string2, classArray);
                        method.setAccessible(true);
                        this.mValueType = clazz3;
                        return method;
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        continue;
                    }
                }
            }
            Log.e((String)"PropertyValuesHolder", (String)("Couldn't find setter/getter for property " + this.mPropertyName + " with value type " + this.mValueType));
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method setupSetterOrGetter(Class clazz, HashMap<Class, HashMap<String, Method>> hashMap, String string, Class clazz2) {
        Method method = null;
        try {
            this.mPropertyMapLock.writeLock().lock();
            HashMap<String, Method> hashMap2 = hashMap.get(clazz);
            if (hashMap2 != null) {
                method = hashMap2.get(this.mPropertyName);
            }
            if (method == null) {
                method = this.getPropertyFunction(clazz, string, clazz2);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    hashMap.put(clazz, hashMap2);
                }
                hashMap2.put(this.mPropertyName, method);
            }
        }
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
        return method;
    }

    void setupSetter(Class clazz) {
        this.mSetter = this.setupSetterOrGetter(clazz, sSetterPropertyMap, "set", this.mValueType);
    }

    private void setupGetter(Class clazz) {
        this.mGetter = this.setupSetterOrGetter(clazz, sGetterPropertyMap, "get", null);
    }

    void setupSetterAndGetter(Object object) {
        if (this.mProperty != null) {
            try {
                Object v = this.mProperty.get(object);
                for (Keyframe keyframe : this.mKeyframeSet.mKeyframes) {
                    if (keyframe.hasValue()) continue;
                    keyframe.setValue(this.mProperty.get(object));
                }
                return;
            }
            catch (ClassCastException classCastException) {
                Log.e((String)"PropertyValuesHolder", (String)("No such property (" + this.mProperty.getName() + ") on target object " + object + ". Trying reflection instead"));
                this.mProperty = null;
            }
        }
        Class<?> clazz = object.getClass();
        if (this.mSetter == null) {
            this.setupSetter(clazz);
        }
        for (Keyframe keyframe : this.mKeyframeSet.mKeyframes) {
            if (keyframe.hasValue()) continue;
            if (this.mGetter == null) {
                this.setupGetter(clazz);
            }
            try {
                keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            }
        }
    }

    private void setupValue(Object object, Keyframe keyframe) {
        if (this.mProperty != null) {
            keyframe.setValue(this.mProperty.get(object));
        }
        try {
            if (this.mGetter == null) {
                Class<?> clazz = object.getClass();
                this.setupGetter(clazz);
            }
            keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
        }
    }

    void setupStartValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(0));
    }

    void setupEndValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(this.mKeyframeSet.mKeyframes.size() - 1));
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder propertyValuesHolder = (PropertyValuesHolder)super.clone();
            propertyValuesHolder.mPropertyName = this.mPropertyName;
            propertyValuesHolder.mProperty = this.mProperty;
            propertyValuesHolder.mKeyframeSet = this.mKeyframeSet.clone();
            propertyValuesHolder.mEvaluator = this.mEvaluator;
            return propertyValuesHolder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void setAnimatedValue(Object object) {
        if (this.mProperty != null) {
            this.mProperty.set(object, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(object, this.mTmpValueArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            }
        }
    }

    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mEvaluator = this.mValueType == Float.class ? sFloatEvaluator : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframeSet.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
        this.mKeyframeSet.setEvaluator(typeEvaluator);
    }

    void calculateValue(float f) {
        this.mAnimatedValue = this.mKeyframeSet.getValue(f);
    }

    public void setPropertyName(String string) {
        this.mPropertyName = string;
    }

    public void setProperty(Property property) {
        this.mProperty = property;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframeSet.toString();
    }

    static String getMethodName(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        char c = Character.toUpperCase(string2.charAt(0));
        String string3 = string2.substring(1);
        return string + c + string3;
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        private FloatProperty mFloatProperty;
        FloatKeyframeSet mFloatKeyframeSet;
        float mFloatAnimatedValue;

        public FloatPropertyValuesHolder(String string, FloatKeyframeSet floatKeyframeSet) {
            super(string);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = floatKeyframeSet;
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        public FloatPropertyValuesHolder(Property property, FloatKeyframeSet floatKeyframeSet) {
            super(property);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = floatKeyframeSet;
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        public FloatPropertyValuesHolder(String string, float ... fArray) {
            super(string);
            this.setFloatValues(fArray);
        }

        public FloatPropertyValuesHolder(Property property, float ... fArray) {
            super(property);
            this.setFloatValues(fArray);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        @Override
        public void setFloatValues(float ... fArray) {
            super.setFloatValues(fArray);
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        @Override
        void calculateValue(float f) {
            this.mFloatAnimatedValue = this.mFloatKeyframeSet.getFloatValue(f);
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder floatPropertyValuesHolder = (FloatPropertyValuesHolder)super.clone();
            floatPropertyValuesHolder.mFloatKeyframeSet = (FloatKeyframeSet)floatPropertyValuesHolder.mKeyframeSet;
            return floatPropertyValuesHolder;
        }

        @Override
        void setAnimatedValue(Object object) {
            if (this.mFloatProperty != null) {
                this.mFloatProperty.setValue(object, this.mFloatAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(object, Float.valueOf(this.mFloatAnimatedValue));
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(object, this.mTmpValueArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                }
            }
        }

        @Override
        void setupSetter(Class clazz) {
            if (this.mProperty != null) {
                return;
            }
            super.setupSetter(clazz);
        }
    }

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        private IntProperty mIntProperty;
        IntKeyframeSet mIntKeyframeSet;
        int mIntAnimatedValue;

        public IntPropertyValuesHolder(String string, IntKeyframeSet intKeyframeSet) {
            super(string);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = intKeyframeSet;
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        public IntPropertyValuesHolder(Property property, IntKeyframeSet intKeyframeSet) {
            super(property);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = intKeyframeSet;
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        public IntPropertyValuesHolder(String string, int ... nArray) {
            super(string);
            this.setIntValues(nArray);
        }

        public IntPropertyValuesHolder(Property property, int ... nArray) {
            super(property);
            this.setIntValues(nArray);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        @Override
        public void setIntValues(int ... nArray) {
            super.setIntValues(nArray);
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        @Override
        void calculateValue(float f) {
            this.mIntAnimatedValue = this.mIntKeyframeSet.getIntValue(f);
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        @Override
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder intPropertyValuesHolder = (IntPropertyValuesHolder)super.clone();
            intPropertyValuesHolder.mIntKeyframeSet = (IntKeyframeSet)intPropertyValuesHolder.mKeyframeSet;
            return intPropertyValuesHolder;
        }

        @Override
        void setAnimatedValue(Object object) {
            if (this.mIntProperty != null) {
                this.mIntProperty.setValue(object, this.mIntAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(object, this.mIntAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = this.mIntAnimatedValue;
                    this.mSetter.invoke(object, this.mTmpValueArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                }
            }
        }

        @Override
        void setupSetter(Class clazz) {
            if (this.mProperty != null) {
                return;
            }
            super.setupSetter(clazz);
        }
    }
}

