/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.UriMatcher;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContactsPhotoBitmapHunter
extends BitmapHunter {
    private static final int ID_LOOKUP = 1;
    private static final int ID_THUMBNAIL = 2;
    private static final int ID_CONTACT = 3;
    private static final int ID_DISPLAY_PHOTO = 4;
    private static final UriMatcher matcher = new UriMatcher(-1);
    final Context context;

    ContactsPhotoBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bitmap decode(Request request) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            Bitmap bitmap = this.decodeStream(inputStream, request);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    private InputStream getInputStream() throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        Uri uri = this.getData().uri;
        switch (matcher.match(uri)) {
            case 1: {
                uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri);
                if (uri == null) {
                    return null;
                }
            }
            case 3: {
                if (Build.VERSION.SDK_INT < 14) {
                    return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri);
                }
                return ContactPhotoStreamIcs.get(contentResolver, uri);
            }
            case 2: 
            case 4: {
                return contentResolver.openInputStream(uri);
            }
        }
        throw new IllegalStateException("Invalid uri: " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeStream(InputStream inputStream, Request request) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BitmapFactory.Options options = null;
        if (request.hasSize()) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            InputStream inputStream2 = this.getInputStream();
            try {
                BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(inputStream2);
            }
            ContactsPhotoBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, options);
        }
        return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
    }

    static {
        matcher.addURI("com.android.contacts", "contacts/lookup/*/#", 1);
        matcher.addURI("com.android.contacts", "contacts/lookup/*", 1);
        matcher.addURI("com.android.contacts", "contacts/#/photo", 2);
        matcher.addURI("com.android.contacts", "contacts/#", 3);
        matcher.addURI("com.android.contacts", "display_photo/#", 4);
    }

    @TargetApi(value=14)
    private static class ContactPhotoStreamIcs {
        private ContactPhotoStreamIcs() {
        }

        static InputStream get(ContentResolver contentResolver, Uri uri) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri, (boolean)true);
        }
    }
}

