/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Intent;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.ActivityResultHandlerMap;

public class ActivityHandlerHelper {
    private static final String LOGTAG = "GeckoActivityHandlerHelper";
    private static final ActivityResultHandlerMap mActivityResultHandlerMap = new ActivityResultHandlerMap();

    private static int makeRequestCode(ActivityResultHandler activityResultHandler) {
        return mActivityResultHandlerMap.put(activityResultHandler);
    }

    public static void startIntent(Intent intent, ActivityResultHandler activityResultHandler) {
        ActivityHandlerHelper.startIntentForActivity(GeckoAppShell.getGeckoInterface().getActivity(), intent, activityResultHandler);
    }

    public static void startIntentForActivity(Activity activity, Intent intent, ActivityResultHandler activityResultHandler) {
        activity.startActivityForResult(intent, mActivityResultHandlerMap.put(activityResultHandler));
    }

    public static boolean handleActivityResult(int n, int n2, Intent intent) {
        ActivityResultHandler activityResultHandler = mActivityResultHandlerMap.getAndRemove(n);
        if (activityResultHandler != null) {
            activityResultHandler.onActivityResult(n2, intent);
            return true;
        }
        return false;
    }
}

