/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.TargetApi;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

@RobocopTarget
public class RestrictedProfiles {
    private static final String LOGTAG = "GeckoRestrictedProfiles";
    private static Boolean inGuest = null;
    private static final List<String> BANNED_SCHEMES = new ArrayList<String>(){
        {
            this.add("file");
            this.add("chrome");
            this.add("resource");
            this.add("jar");
            this.add("wyciwyg");
        }
    };
    private static final List<String> BANNED_URLS = new ArrayList<String>(){
        {
            this.add("about:config");
        }
    };

    private static boolean getInGuest() {
        if (inGuest == null) {
            inGuest = GeckoAppShell.getGeckoInterface().getProfile().inGuestMode();
        }
        return inGuest;
    }

    private static Restriction geckoActionToRestriction(int n) {
        for (Restriction restriction : Restriction.values()) {
            if (restriction.id != n) continue;
            return restriction;
        }
        throw new IllegalArgumentException("Unknown action " + n);
    }

    @TargetApi(value=17)
    @RobocopTarget
    private static Bundle getRestrictions() {
        UserManager userManager = (UserManager)GeckoAppShell.getContext().getSystemService("user");
        return userManager.getUserRestrictions();
    }

    private static boolean getRestriction(String string2) {
        if (AppConstants.Versions.preJBMR2) {
            return false;
        }
        return RestrictedProfiles.getRestrictions().getBoolean(string2, false);
    }

    private static boolean canLoadUrl(String string2) {
        if (string2 == null) {
            return true;
        }
        try {
            if (!RestrictedProfiles.getInGuest() && !RestrictedProfiles.getRestriction(Restriction.DISALLOW_BROWSE_FILES.name)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.i((String)LOGTAG, (String)"Invalid action", (Throwable)illegalArgumentException);
        }
        Uri uri = Uri.parse((String)string2);
        String string3 = uri.getScheme();
        if (BANNED_SCHEMES.contains(string3)) {
            return false;
        }
        for (String string4 : BANNED_URLS) {
            if (!string2.startsWith(string4)) continue;
            return false;
        }
        return true;
    }

    @WrapElementForJNI
    public static boolean isUserRestricted() {
        if (RestrictedProfiles.getInGuest()) {
            return true;
        }
        if (AppConstants.Versions.preJBMR2) {
            return false;
        }
        return !RestrictedProfiles.getRestrictions().isEmpty();
    }

    public static boolean isAllowed(Restriction restriction) {
        return RestrictedProfiles.isAllowed(restriction.id, null);
    }

    @WrapElementForJNI
    public static boolean isAllowed(int n, String string2) {
        Restriction restriction;
        if (RestrictedProfiles.getInGuest()) {
            return false;
        }
        try {
            restriction = RestrictedProfiles.geckoActionToRestriction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)LOGTAG, (String)("Unknown action " + n + "; check calling code."));
            return false;
        }
        if (Restriction.DISALLOW_BROWSE_FILES == restriction) {
            return RestrictedProfiles.canLoadUrl(string2);
        }
        return !RestrictedProfiles.getRestriction(restriction.name);
    }

    @WrapElementForJNI
    public static String getUserRestrictions() {
        if (RestrictedProfiles.getInGuest()) {
            StringBuilder stringBuilder = new StringBuilder("{ ");
            for (Restriction restriction : Restriction.values()) {
                stringBuilder.append("\"" + restriction.name + "\": true, ");
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
        if (AppConstants.Versions.preJBMR2) {
            return "{}";
        }
        JSONObject jSONObject = new JSONObject();
        Bundle bundle = RestrictedProfiles.getRestrictions();
        Set set = bundle.keySet();
        for (String string2 : set) {
            try {
                jSONObject.put(string2, bundle.get(string2));
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject.toString();
    }

    public static enum Restriction {
        DISALLOW_DOWNLOADS(1, "no_download_files"),
        DISALLOW_INSTALL_EXTENSION(2, "no_install_extensions"),
        DISALLOW_INSTALL_APPS(3, "no_install_apps"),
        DISALLOW_BROWSE_FILES(4, "no_browse_files"),
        DISALLOW_SHARE(5, "no_share"),
        DISALLOW_BOOKMARK(6, "no_bookmark"),
        DISALLOW_ADD_CONTACTS(7, "no_add_contacts"),
        DISALLOW_SET_IMAGE(8, "no_set_image"),
        DISALLOW_MODIFY_ACCOUNTS(9, "no_modify_accounts"),
        DISALLOW_REMOTE_DEBUGGING(10, "no_remote_debugging"),
        DISALLOW_IMPORT_SETTINGS(11, "no_import_settings");

        public final int id;
        public final String name;

        private Restriction(int n2, String string3) {
            this.id = n2;
            this.name = string3;
        }
    }
}

