/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.db;

import android.content.ContentValues;
import android.database.Cursor;
import org.json.simple.JSONArray;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;

public class Tab {
    public final String title;
    public final String icon;
    public final JSONArray history;
    public final long lastUsed;

    public Tab(String string2, String string3, JSONArray jSONArray, long l) {
        this.title = string2;
        this.icon = string3;
        this.history = jSONArray;
        this.lastUsed = l;
    }

    public ContentValues toContentValues(String string2, int n) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("position", Integer.valueOf(n));
        contentValues.put("client_guid", string2);
        contentValues.put("favicon", this.icon);
        contentValues.put("last_used", Long.valueOf(this.lastUsed));
        contentValues.put("title", this.title);
        contentValues.put("url", (String)this.history.get(0));
        contentValues.put("history", this.history.toJSONString());
        return contentValues;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tab)) {
            return false;
        }
        Tab tab = (Tab)object;
        if (!RepoUtils.stringsEqual(this.title, tab.title)) {
            return false;
        }
        if (!RepoUtils.stringsEqual(this.icon, tab.icon)) {
            return false;
        }
        if (this.lastUsed != tab.lastUsed) {
            return false;
        }
        return Utils.sameArrays(this.history, tab.history);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static Tab fromCursor(Cursor cursor) {
        String string2 = RepoUtils.getStringFromCursor(cursor, "title");
        String string3 = RepoUtils.getStringFromCursor(cursor, "favicon");
        JSONArray jSONArray = RepoUtils.getJSONArrayFromCursor(cursor, "history");
        long l = RepoUtils.getLongFromCursor(cursor, "last_used");
        return new Tab(string2, string3, jSONArray, l);
    }
}

