/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.database.Cursor;
import android.util.SparseArray;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.background.common.DateUtils;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.Environment;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;
import org.mozilla.gecko.background.healthreport.HealthReportUtils;
import org.mozilla.gecko.background.healthreport.ProfileInformationCache;

public class HealthReportGenerator {
    private static final int PAYLOAD_VERSION = 3;
    private static final String LOG_TAG = "GeckoHealthGen";
    private final HealthReportStorage storage;
    private final DateUtils.DateFormatter dateFormatter;

    public HealthReportGenerator(HealthReportStorage healthReportStorage) {
        this.storage = healthReportStorage;
        this.dateFormatter = new DateUtils.DateFormatter();
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public JSONObject generateDocument(long l, long l2, String string2, EnvironmentBuilder.ConfigurationProvider configurationProvider) throws JSONException {
        Logger.info(LOG_TAG, "Generating FHR document from " + l + "; last ping " + l2);
        Logger.pii(LOG_TAG, "Generating for profile " + string2);
        ProfileInformationCache profileInformationCache = new ProfileInformationCache(string2);
        if (!profileInformationCache.restoreUnlessInitialized()) {
            Logger.warn(LOG_TAG, "Not enough profile information to compute current environment.");
            return null;
        }
        Environment environment = EnvironmentBuilder.getCurrentEnvironment(profileInformationCache, configurationProvider);
        return this.generateDocument(l, l2, environment);
    }

    public JSONObject generateDocument(long l, long l2, Environment environment) throws JSONException {
        String string2 = environment.getHash();
        Logger.debug(LOG_TAG, "Current environment hash: " + string2);
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Current hash is null; aborting.");
            return null;
        }
        SparseArray<Environment> sparseArray = this.storage.getEnvironmentRecordsByID();
        JSONObject jSONObject = new JSONObject();
        if (l2 >= 1367500000000L) {
            jSONObject.put("lastPingDate", (Object)this.dateFormatter.getDateString(l2));
        }
        jSONObject.put("thisPingDate", (Object)this.dateFormatter.getDateString(this.now()));
        jSONObject.put("version", 3);
        jSONObject.put("environments", (Object)HealthReportGenerator.getEnvironmentsJSON(environment, sparseArray));
        jSONObject.put("data", (Object)this.getDataJSON(environment, sparseArray, l));
        return jSONObject;
    }

    protected JSONObject getDataJSON(Environment environment, SparseArray<Environment> sparseArray, long l) throws JSONException {
        SparseArray<HealthReportStorage.Field> sparseArray2 = this.storage.getFieldsByID();
        JSONObject jSONObject = this.getDaysJSON(environment, sparseArray, sparseArray2, l);
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("days", (Object)jSONObject);
        jSONObject3.put("last", (Object)jSONObject2);
        return jSONObject3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getDaysJSON(Environment environment, SparseArray<Environment> sparseArray, SparseArray<HealthReportStorage.Field> sparseArray2, long l) throws JSONException {
        if (Logger.shouldLogVerbose(LOG_TAG)) {
            for (int i = 0; i < sparseArray.size(); ++i) {
                Logger.trace(LOG_TAG, "Days environment " + sparseArray.keyAt(i) + ": " + ((Environment)sparseArray.get(sparseArray.keyAt(i))).getHash());
            }
        }
        JSONObject jSONObject = new JSONObject();
        try (Cursor cursor = this.storage.getRawEventsSince(l);){
            if (!cursor.moveToFirst()) {
                JSONObject jSONObject2 = jSONObject;
                return jSONObject2;
            }
            int n = -1;
            int n2 = -1;
            JSONObject jSONObject3 = null;
            JSONObject jSONObject4 = null;
            while (!cursor.isAfterLast()) {
                boolean bl;
                int n3 = cursor.getInt(1);
                if (n3 == -1 || n3 != n2 && sparseArray.indexOfKey(n3) < 0) {
                    Logger.warn(LOG_TAG, "Invalid environment " + n3 + " in cursor. Skipping.");
                    cursor.moveToNext();
                    continue;
                }
                int n4 = cursor.getInt(0);
                int n5 = cursor.getInt(2);
                Logger.trace(LOG_TAG, "Event row: " + n4 + ", " + n3 + ", " + n5);
                boolean bl2 = n4 != n;
                boolean bl3 = bl = n3 != n2;
                if (bl2) {
                    if (jSONObject3 != null) {
                        jSONObject.put(this.dateFormatter.getDateStringForDay(n), (Object)jSONObject3);
                    }
                    jSONObject3 = new JSONObject();
                    n = n4;
                }
                if (bl2 || bl) {
                    jSONObject4 = new JSONObject();
                    jSONObject3.put(((Environment)sparseArray.get(n3)).getHash(), (Object)jSONObject4);
                    n2 = n3;
                }
                HealthReportStorage.Field field = (HealthReportStorage.Field)sparseArray2.get(n5);
                JSONObject jSONObject5 = jSONObject4.optJSONObject(field.measurementName);
                if (jSONObject5 == null) {
                    jSONObject5 = new JSONObject();
                    jSONObject5.put("_v", (Object)field.measurementVersion);
                    jSONObject4.put(field.measurementName, (Object)jSONObject5);
                }
                HealthReportGenerator.recordMeasurementFromCursor(field, jSONObject5, cursor);
                cursor.moveToNext();
            }
            jSONObject.put(this.dateFormatter.getDateStringForDay(n), jSONObject3);
        }
        return jSONObject;
    }

    private static Object getJSONAtIndex(Cursor cursor, int n) throws JSONException {
        if (cursor.isNull(n)) {
            return JSONObject.NULL;
        }
        String string2 = cursor.getString(n);
        if ("null".equals(string2)) {
            return JSONObject.NULL;
        }
        return new JSONObject(string2);
    }

    protected static void recordMeasurementFromCursor(HealthReportStorage.Field field, JSONObject jSONObject, Cursor cursor) throws JSONException {
        if (field.isDiscreteField()) {
            if (field.isCountedField()) {
                if (!field.isStringField()) {
                    throw new IllegalStateException("Unable to handle non-string counted types.");
                }
                HealthReportUtils.count(jSONObject, field.fieldName, cursor.getString(3));
                return;
            }
            if (field.isStringField()) {
                HealthReportUtils.append(jSONObject, field.fieldName, cursor.getString(3));
                return;
            }
            if (field.isJSONField()) {
                HealthReportUtils.append(jSONObject, field.fieldName, HealthReportGenerator.getJSONAtIndex(cursor, 3));
                return;
            }
            if (field.isIntegerField()) {
                HealthReportUtils.append(jSONObject, field.fieldName, cursor.getLong(3));
                return;
            }
            throw new IllegalStateException("Unknown field type: " + field.flags);
        }
        if (field.isStringField()) {
            jSONObject.put(field.fieldName, (Object)cursor.getString(3));
            return;
        }
        if (field.isJSONField()) {
            jSONObject.put(field.fieldName, HealthReportGenerator.getJSONAtIndex(cursor, 3));
            return;
        }
        jSONObject.put(field.fieldName, cursor.getLong(3));
    }

    public static JSONObject getEnvironmentsJSON(Environment environment, SparseArray<Environment> sparseArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("current", (Object)HealthReportGenerator.jsonify(environment, null));
        String string2 = environment.getHash();
        for (int i = 0; i < sparseArray.size(); ++i) {
            Environment environment2 = (Environment)sparseArray.valueAt(i);
            if (string2.equals(environment2.getHash())) continue;
            jSONObject.put(environment2.getHash(), (Object)HealthReportGenerator.jsonify(environment2, environment));
        }
        return jSONObject;
    }

    public static JSONObject jsonify(Environment environment, Environment environment2) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = HealthReportGenerator.getProfileAge(environment, environment2);
        JSONObject jSONObject3 = HealthReportGenerator.getSysInfo(environment, environment2);
        JSONObject jSONObject4 = HealthReportGenerator.getGeckoInfo(environment, environment2);
        JSONObject jSONObject5 = HealthReportGenerator.getAppInfo(environment, environment2);
        JSONObject jSONObject6 = HealthReportGenerator.getAddonCounts(environment, environment2);
        JSONObject jSONObject7 = HealthReportGenerator.getDeviceConfig(environment, environment2);
        JSONObject jSONObject8 = new JSONObject();
        if (jSONObject2 != null) {
            jSONObject8.put("org.mozilla.profile.age", (Object)jSONObject2);
        }
        if (jSONObject3 != null) {
            jSONObject8.put("org.mozilla.sysinfo.sysinfo", (Object)jSONObject3);
        }
        if (jSONObject4 != null) {
            jSONObject8.put("geckoAppInfo", (Object)jSONObject4);
        }
        if (jSONObject5 != null) {
            jSONObject8.put("org.mozilla.appInfo.appinfo", (Object)jSONObject5);
        }
        if (jSONObject6 != null) {
            jSONObject8.put("org.mozilla.addons.counts", (Object)jSONObject6);
        }
        if ((jSONObject = HealthReportGenerator.getActiveAddons(environment, environment2)) != null) {
            jSONObject8.put("org.mozilla.addons.active", (Object)jSONObject);
        }
        if (jSONObject7 != null) {
            jSONObject8.put("org.mozilla.device.config", (Object)jSONObject7);
        }
        if (environment2 == null) {
            jSONObject8.put("hash", (Object)environment.getHash());
        }
        return jSONObject8;
    }

    private static JSONObject getDeviceConfig(Environment environment, Environment environment2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n = 0;
        if (environment.version < 3) {
            return null;
        }
        if (environment2 != null && environment2.version < 3) {
            return HealthReportGenerator.getDeviceConfig(environment, null);
        }
        if (environment2 == null || environment2.hasHardwareKeyboard != environment.hasHardwareKeyboard) {
            jSONObject.put("hasHardwareKeyboard", environment.hasHardwareKeyboard);
            ++n;
        }
        if (environment2 == null || environment2.screenLayout != environment.screenLayout) {
            jSONObject.put("screenLayout", environment.screenLayout);
            ++n;
        }
        if (environment2 == null || environment2.screenXInMM != environment.screenXInMM) {
            jSONObject.put("screenXInMM", environment.screenXInMM);
            ++n;
        }
        if (environment2 == null || environment2.screenYInMM != environment.screenYInMM) {
            jSONObject.put("screenYInMM", environment.screenYInMM);
            ++n;
        }
        if (environment2 == null || environment2.uiType != environment.uiType) {
            jSONObject.put("uiType", (Object)environment.uiType.toString());
            ++n;
        }
        if (environment2 == null || environment2.uiMode != environment.uiMode) {
            jSONObject.put("uiMode", environment.uiMode);
            ++n;
        }
        if (environment2 != null && n == 0) {
            return null;
        }
        jSONObject.put("_v", 1);
        return jSONObject;
    }

    private static JSONObject getProfileAge(Environment environment, Environment environment2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n = 0;
        if (environment2 == null || environment2.profileCreation != environment.profileCreation) {
            jSONObject.put("profileCreation", environment.profileCreation);
            ++n;
        }
        if (environment2 != null && n == 0) {
            return null;
        }
        jSONObject.put("_v", 1);
        return jSONObject;
    }

    private static JSONObject getSysInfo(Environment environment, Environment environment2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n = 0;
        if (environment2 == null || environment2.cpuCount != environment.cpuCount) {
            jSONObject.put("cpuCount", environment.cpuCount);
            ++n;
        }
        if (environment2 == null || environment2.memoryMB != environment.memoryMB) {
            jSONObject.put("memoryMB", environment.memoryMB);
            ++n;
        }
        if (environment2 == null || !environment2.architecture.equals(environment.architecture)) {
            jSONObject.put("architecture", (Object)environment.architecture);
            ++n;
        }
        if (environment2 == null || !environment2.sysName.equals(environment.sysName)) {
            jSONObject.put("name", (Object)environment.sysName);
            ++n;
        }
        if (environment2 == null || !environment2.sysVersion.equals(environment.sysVersion)) {
            jSONObject.put("version", (Object)environment.sysVersion);
            ++n;
        }
        if (environment2 != null && n == 0) {
            return null;
        }
        jSONObject.put("_v", 1);
        return jSONObject;
    }

    private static JSONObject getGeckoInfo(Environment environment, Environment environment2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n = 0;
        if (environment2 == null || !environment2.vendor.equals(environment.vendor)) {
            jSONObject.put("vendor", (Object)environment.vendor);
            ++n;
        }
        if (environment2 == null || !environment2.appName.equals(environment.appName)) {
            jSONObject.put("name", (Object)environment.appName);
            ++n;
        }
        if (environment2 == null || !environment2.appID.equals(environment.appID)) {
            jSONObject.put("id", (Object)environment.appID);
            ++n;
        }
        if (environment2 == null || !environment2.appVersion.equals(environment.appVersion)) {
            jSONObject.put("version", (Object)environment.appVersion);
            ++n;
        }
        if (environment2 == null || !environment2.appBuildID.equals(environment.appBuildID)) {
            jSONObject.put("appBuildID", (Object)environment.appBuildID);
            ++n;
        }
        if (environment2 == null || !environment2.platformVersion.equals(environment.platformVersion)) {
            jSONObject.put("platformVersion", (Object)environment.platformVersion);
            ++n;
        }
        if (environment2 == null || !environment2.platformBuildID.equals(environment.platformBuildID)) {
            jSONObject.put("platformBuildID", (Object)environment.platformBuildID);
            ++n;
        }
        if (environment2 == null || !environment2.os.equals(environment.os)) {
            jSONObject.put("os", (Object)environment.os);
            ++n;
        }
        if (environment2 == null || !environment2.xpcomabi.equals(environment.xpcomabi)) {
            jSONObject.put("xpcomabi", (Object)environment.xpcomabi);
            ++n;
        }
        if (environment2 == null || !environment2.updateChannel.equals(environment.updateChannel)) {
            jSONObject.put("updateChannel", (Object)environment.updateChannel);
            ++n;
        }
        if (environment2 != null && n == 0) {
            return null;
        }
        jSONObject.put("_v", 1);
        return jSONObject;
    }

    private static boolean stringsDiffer(String string2, String string3) {
        if (string2 == null) {
            return string3 != null;
        }
        return !string2.equals(string3);
    }

    private static JSONObject getAppInfo(Environment environment, Environment environment2) throws JSONException {
        boolean bl;
        JSONObject jSONObject = new JSONObject();
        Logger.debug(LOG_TAG, "Generating appinfo for v" + environment.version + " env " + environment.hash);
        boolean bl2 = environment2 == null || environment.version > environment2.version;
        boolean bl3 = bl = bl2 || environment2.version > environment.version;
        switch (environment.version) {
            case 2: 
            case 3: {
                jSONObject.put("_v", 3);
                break;
            }
            case 1: {
                jSONObject.put("_v", 2);
                break;
            }
            default: {
                Logger.warn(LOG_TAG, "Unknown environment version: " + environment.version);
                return jSONObject;
            }
        }
        switch (environment.version) {
            case 2: 
            case 3: {
                if (HealthReportGenerator.populateAppInfoV2(jSONObject, environment, environment2, bl2)) {
                    bl3 = true;
                }
            }
            case 1: {
                if (!HealthReportGenerator.populateAppInfoV1(environment, environment2, jSONObject)) break;
                bl3 = true;
            }
        }
        if (!bl3) {
            return null;
        }
        return jSONObject;
    }

    private static boolean populateAppInfoV1(Environment environment, Environment environment2, JSONObject jSONObject) throws JSONException {
        boolean bl = false;
        if (environment2 == null || environment2.isBlocklistEnabled != environment.isBlocklistEnabled) {
            jSONObject.put("isBlocklistEnabled", environment.isBlocklistEnabled);
            bl = true;
        }
        if (environment2 == null || environment2.isTelemetryEnabled != environment.isTelemetryEnabled) {
            jSONObject.put("isTelemetryEnabled", environment.isTelemetryEnabled);
            bl = true;
        }
        return bl;
    }

    private static boolean populateAppInfoV2(JSONObject jSONObject, Environment environment, Environment environment2, boolean bl) throws JSONException {
        boolean bl2 = false;
        if (bl || HealthReportGenerator.stringsDiffer(environment2.osLocale, environment.osLocale)) {
            jSONObject.put("osLocale", (Object)environment.osLocale);
            bl2 = true;
        }
        if (bl || HealthReportGenerator.stringsDiffer(environment2.appLocale, environment.appLocale)) {
            jSONObject.put("appLocale", (Object)environment.appLocale);
            bl2 = true;
        }
        if (bl || HealthReportGenerator.stringsDiffer(environment2.distribution, environment.distribution)) {
            jSONObject.put("distribution", (Object)environment.distribution);
            bl2 = true;
        }
        if (bl || environment2.acceptLangSet != environment.acceptLangSet) {
            jSONObject.put("acceptLangIsUserSet", environment.acceptLangSet);
            bl2 = true;
        }
        return bl2;
    }

    private static JSONObject getAddonCounts(Environment environment, Environment environment2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n = 0;
        if (environment2 == null || environment2.extensionCount != environment.extensionCount) {
            jSONObject.put("extension", environment.extensionCount);
            ++n;
        }
        if (environment2 == null || environment2.pluginCount != environment.pluginCount) {
            jSONObject.put("plugin", environment.pluginCount);
            ++n;
        }
        if (environment2 == null || environment2.themeCount != environment.themeCount) {
            jSONObject.put("theme", environment.themeCount);
            ++n;
        }
        if (environment2 != null && n == 0) {
            return null;
        }
        jSONObject.put("_v", 1);
        return jSONObject;
    }

    public static JSONObject diff(JSONObject jSONObject, JSONObject jSONObject2, boolean bl) throws JSONException {
        Object object;
        Iterator iterator;
        Object object2;
        if (jSONObject == null) {
            return jSONObject2;
        }
        if (jSONObject2 == null) {
            return HealthReportGenerator.diff(jSONObject, new JSONObject(), bl);
        }
        JSONObject jSONObject3 = new JSONObject();
        HashSet<Object> hashSet = bl ? new HashSet<Object>(jSONObject2.length()) : null;
        Iterator iterator2 = jSONObject2.keys();
        while (iterator2.hasNext()) {
            object2 = (String)iterator2.next();
            if (bl) {
                hashSet.add(object2);
            }
            iterator = jSONObject2.get((String)object2);
            if (!jSONObject.has((String)object2)) {
                jSONObject3.put((String)object2, iterator);
                continue;
            }
            object = jSONObject.get((String)object2);
            if (object instanceof JSONObject && iterator instanceof JSONObject) {
                JSONObject jSONObject4 = HealthReportGenerator.diff((JSONObject)object, (JSONObject)iterator, bl);
                if (jSONObject4 == null) continue;
                jSONObject3.put((String)object2, (Object)jSONObject4);
                continue;
            }
            if (iterator.equals(object)) continue;
            jSONObject3.put((String)object2, iterator);
        }
        if (bl) {
            object2 = HealthReportUtils.keySet(jSONObject);
            object2.removeAll(hashSet);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                jSONObject3.put((String)object, JSONObject.NULL);
            }
        }
        if (jSONObject3.length() == 0) {
            return null;
        }
        return jSONObject3;
    }

    private static JSONObject getActiveAddons(Environment environment, Environment environment2) throws JSONException {
        if (environment2 == null) {
            JSONObject jSONObject = environment.getNonIgnoredAddons();
            if (jSONObject == null) {
                Logger.warn(LOG_TAG, "Null add-ons to return in FHR document. Returning {}.");
                jSONObject = new JSONObject();
            }
            jSONObject.put("_v", 1);
            return jSONObject;
        }
        JSONObject jSONObject = HealthReportGenerator.diff(environment2.getNonIgnoredAddons(), environment.getNonIgnoredAddons(), true);
        if (jSONObject == null) {
            return null;
        }
        if (jSONObject == environment.addons) {
            return HealthReportGenerator.getActiveAddons(environment, null);
        }
        jSONObject.put("_v", 1);
        return jSONObject;
    }
}

