/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.db.SuggestedSites;
import org.mozilla.gecko.db.TopSitesCursorWrapper;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.StringUtils;

public class BrowserDB {
    private static volatile LocalBrowserDB sDb;
    private static volatile SuggestedSites sSuggestedSites;
    private static volatile boolean sAreContentProvidersEnabled;

    public static void initialize(String string2) {
        sDb = new LocalBrowserDB(string2);
    }

    public static int addDefaultBookmarks(Context context, ContentResolver contentResolver, int n) {
        return sDb.addDefaultBookmarks(context, contentResolver, n);
    }

    public static int addDistributionBookmarks(ContentResolver contentResolver, Distribution distribution, int n) {
        return sDb.addDistributionBookmarks(contentResolver, distribution, n);
    }

    public static void setSuggestedSites(SuggestedSites suggestedSites) {
        sSuggestedSites = suggestedSites;
    }

    public static boolean hideSuggestedSite(String string2) {
        return sSuggestedSites.hideSite(string2);
    }

    public static void invalidateCachedState() {
        sDb.invalidateCachedState();
    }

    @RobocopTarget
    public static Cursor filter(ContentResolver contentResolver, CharSequence charSequence, int n, EnumSet<FilterFlags> enumSet) {
        return sDb.filter(contentResolver, charSequence, n, enumSet);
    }

    private static void appendUrlsFromCursor(List<String> list, Cursor cursor) {
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            String string2 = cursor.getString(cursor.getColumnIndex("url"));
            if (StringUtils.isUserEnteredUrl((String)string2)) {
                string2 = StringUtils.decodeUserEnteredUrl((String)string2);
            }
            list.add(string2);
        }
    }

    public static Cursor getTopSites(ContentResolver contentResolver, int n, int n2) {
        int n3;
        Cursor cursor = sDb.getPinnedSites(contentResolver, n);
        int n4 = cursor.getCount();
        Cursor cursor2 = sDb.getTopSites(contentResolver, n2 - n4);
        int n5 = cursor2.getCount();
        Cursor cursor3 = null;
        if (sSuggestedSites != null && (n3 = n - n4 - n5) > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(n4 + n5);
            BrowserDB.appendUrlsFromCursor(arrayList, cursor);
            BrowserDB.appendUrlsFromCursor(arrayList, cursor2);
            cursor3 = sSuggestedSites.get(n3, arrayList);
        }
        return new TopSitesCursorWrapper(cursor, cursor2, cursor3, n);
    }

    public static void updateVisitedHistory(ContentResolver contentResolver, String string2) {
        if (sAreContentProvidersEnabled) {
            sDb.updateVisitedHistory(contentResolver, string2);
        }
    }

    public static void updateHistoryTitle(ContentResolver contentResolver, String string2, String string3) {
        if (sAreContentProvidersEnabled) {
            sDb.updateHistoryTitle(contentResolver, string2, string3);
        }
    }

    @RobocopTarget
    public static Cursor getAllVisitedHistory(ContentResolver contentResolver) {
        return sAreContentProvidersEnabled ? sDb.getAllVisitedHistory(contentResolver) : null;
    }

    public static Cursor getRecentHistory(ContentResolver contentResolver, int n) {
        return sDb.getRecentHistory(contentResolver, n);
    }

    public static void expireHistory(ContentResolver contentResolver, BrowserContract.ExpirePriority expirePriority) {
        if (sDb == null) {
            return;
        }
        sDb.expireHistory(contentResolver, expirePriority == null ? BrowserContract.ExpirePriority.NORMAL : expirePriority);
    }

    @RobocopTarget
    public static void removeHistoryEntry(ContentResolver contentResolver, String string2) {
        sDb.removeHistoryEntry(contentResolver, string2);
    }

    @RobocopTarget
    public static void clearHistory(ContentResolver contentResolver) {
        sDb.clearHistory(contentResolver);
    }

    @RobocopTarget
    public static Cursor getBookmarksInFolder(ContentResolver contentResolver, long l) {
        return sDb.getBookmarksInFolder(contentResolver, l);
    }

    @RobocopTarget
    public static Cursor getReadingList(ContentResolver contentResolver) {
        return sDb.getReadingList(contentResolver);
    }

    public static String getUrlForKeyword(ContentResolver contentResolver, String string2) {
        return sDb.getUrlForKeyword(contentResolver, string2);
    }

    @RobocopTarget
    public static boolean isBookmark(ContentResolver contentResolver, String string2) {
        return sAreContentProvidersEnabled && sDb.isBookmark(contentResolver, string2);
    }

    public static boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        return sAreContentProvidersEnabled && sDb.isReadingListItem(contentResolver, string2);
    }

    public static void addBookmark(ContentResolver contentResolver, String string2, String string3) {
        sDb.addBookmark(contentResolver, string2, string3);
    }

    @RobocopTarget
    public static void removeBookmarksWithURL(ContentResolver contentResolver, String string2) {
        sDb.removeBookmarksWithURL(contentResolver, string2);
    }

    @RobocopTarget
    public static void updateBookmark(ContentResolver contentResolver, int n, String string2, String string3, String string4) {
        sDb.updateBookmark(contentResolver, n, string2, string3, string4);
    }

    public static void addReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        sDb.addReadingListItem(contentResolver, contentValues);
    }

    public static void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        sDb.removeReadingListItemWithURL(contentResolver, string2);
    }

    public static LoadFaviconResult getFaviconForFaviconUrl(ContentResolver contentResolver, String string2) {
        return sDb.getFaviconForUrl(contentResolver, string2);
    }

    public static String getFaviconURLFromPageURL(ContentResolver contentResolver, String string2) {
        return sDb.getFaviconURLFromPageURL(contentResolver, string2);
    }

    public static void updateFaviconForUrl(ContentResolver contentResolver, String string2, byte[] byArray, String string3) {
        sDb.updateFaviconForUrl(contentResolver, string2, byArray, string3);
    }

    public static void updateThumbnailForUrl(ContentResolver contentResolver, String string2, BitmapDrawable bitmapDrawable) {
        sDb.updateThumbnailForUrl(contentResolver, string2, bitmapDrawable);
    }

    @RobocopTarget
    public static byte[] getThumbnailForUrl(ContentResolver contentResolver, String string2) {
        return sDb.getThumbnailForUrl(contentResolver, string2);
    }

    public static Cursor getThumbnailsForUrls(ContentResolver contentResolver, List<String> list) {
        return sDb.getThumbnailsForUrls(contentResolver, list);
    }

    @RobocopTarget
    public static void removeThumbnails(ContentResolver contentResolver) {
        sDb.removeThumbnails(contentResolver);
    }

    public static void registerBookmarkObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        sDb.registerBookmarkObserver(contentResolver, contentObserver);
    }

    public static int getCount(ContentResolver contentResolver, String string2) {
        return sDb.getCount(contentResolver, string2);
    }

    public static void pinSite(ContentResolver contentResolver, String string2, String string3, int n) {
        sDb.pinSite(contentResolver, string2, string3, n);
    }

    public static void unpinSite(ContentResolver contentResolver, int n) {
        sDb.unpinSite(contentResolver, n);
    }

    @RobocopTarget
    public static Cursor getBookmarkForUrl(ContentResolver contentResolver, String string2) {
        return sDb.getBookmarkForUrl(contentResolver, string2);
    }

    public static void setEnableContentProviders(boolean bl) {
        sAreContentProvidersEnabled = bl;
    }

    public static boolean hasSuggestedImageUrl(String string2) {
        return sSuggestedSites.contains(string2);
    }

    public static String getSuggestedImageUrlForUrl(String string2) {
        return sSuggestedSites.getImageUrlForUrl(string2);
    }

    public static int getSuggestedBackgroundColorForUrl(String string2) {
        String string3 = sSuggestedSites.getBackgroundColorForUrl(string2);
        if (string3 != null) {
            return Color.parseColor((String)string3);
        }
        return 0;
    }

    public static int getTrackingIdForUrl(String string2) {
        return sSuggestedSites.getTrackingIdForUrl(string2);
    }

    static {
        sAreContentProvidersEnabled = true;
    }

    public static enum FilterFlags {
        EXCLUDE_PINNED_SITES;

    }
}

