/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;

public class FxAccountAuthenticator
extends AbstractAccountAuthenticator {
    public static final String LOG_TAG = FxAccountAuthenticator.class.getSimpleName();
    protected final Context context;
    protected final AccountManager accountManager;

    public FxAccountAuthenticator(Context context) {
        super(context);
        this.context = context;
        this.accountManager = AccountManager.get((Context)context);
    }

    public Bundle addAccount(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "addAccount");
        Bundle bundle2 = new Bundle();
        if (!"org.mozilla.fennec_fxaccount".equals(string2)) {
            bundle2.putInt("errorCode", -1);
            bundle2.putString("errorMessage", "Not adding unknown account type.");
            return bundle2;
        }
        Intent intent = new Intent(this.context, FxAccountGetStartedActivity.class);
        bundle2.putParcelable("intent", (Parcelable)intent);
        return bundle2;
    }

    public Bundle confirmCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "confirmCredentials");
        return null;
    }

    public Bundle editProperties(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2) {
        Logger.debug(LOG_TAG, "editProperties");
        return null;
    }

    public Bundle getAuthToken(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "getAuthToken");
        Logger.warn(LOG_TAG, "Returning null bundle for getAuthToken.");
        return null;
    }

    public String getAuthTokenLabel(String string2) {
        Logger.debug(LOG_TAG, "getAuthTokenLabel");
        return null;
    }

    public Bundle hasFeatures(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String[] stringArray) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "hasFeatures");
        return null;
    }

    public Bundle updateCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
        Logger.debug(LOG_TAG, "updateCredentials");
        return null;
    }

    public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        Bundle bundle = super.getAccountRemovalAllowed(accountAuthenticatorResponse, account);
        if (bundle == null || !bundle.containsKey("booleanResult") || bundle.containsKey("intent")) {
            return bundle;
        }
        boolean bl = bundle.getBoolean("booleanResult");
        if (!bl) {
            return bundle;
        }
        Intent intent = AndroidFxAccount.makeDeletedAccountIntent(this.context, account);
        Logger.info(LOG_TAG, "Account named " + account.name + " being removed; " + "broadcasting secure intent " + intent.getAction() + ".");
        this.context.sendBroadcast(intent, "org.mozilla.fennec_fxaccount.permission.PER_ACCOUNT_TYPE");
        return bundle;
    }
}

