/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.receivers;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.config.AccountPickler;
import org.mozilla.gecko.sync.repositories.android.FennecTabsRepository;

public class FxAccountDeletedService
extends IntentService {
    public static final String LOG_TAG = FxAccountDeletedService.class.getSimpleName();

    public FxAccountDeletedService() {
        super(LOG_TAG);
    }

    protected void onHandleIntent(Intent intent) {
        long l;
        if (intent == null) {
            Logger.debug(LOG_TAG, "Short-circuiting on null intent.");
            return;
        }
        FxAccountDeletedService fxAccountDeletedService = this;
        long l2 = intent.getLongExtra("account_deleted_intent_version", 0L);
        if (l2 != (l = 1L)) {
            Logger.warn(LOG_TAG, "Intent malformed: version " + l2 + " given but " + "version " + l + "expected. Not cleaning up after deleted Account.");
            return;
        }
        String string2 = intent.getStringExtra("account_deleted_intent_account");
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Intent malformed: no account name given. Not cleaning up after deleted Account.");
            return;
        }
        Logger.info(LOG_TAG, "Firefox account named " + string2 + " being removed; " + "deleting saved pickle file '" + "fxa.account.json" + "'.");
        FxAccountDeletedService.deletePickle((Context)fxAccountDeletedService);
        Logger.info(LOG_TAG, "Deleting the entire clients database and non-local tabs");
        FennecTabsRepository.deleteNonLocalClientsAndTabs((Context)fxAccountDeletedService);
    }

    public static void deletePickle(Context context) {
        try {
            AccountPickler.deletePickle(context, "fxa.account.json");
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting saved pickle file; ignoring.", exception);
        }
    }
}

