/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.util.Log;
import android.view.MotionEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import org.json.JSONException;
import org.mozilla.gecko.gfx.PointUtils;

class SimpleScaleGestureDetector {
    private static final String LOGTAG = "GeckoSimpleScaleGestureDetector";
    private final SimpleScaleGestureListener mListener;
    private long mLastEventTime;
    private boolean mScaleResult;
    private final LinkedList<PointerInfo> mPointerInfo;

    SimpleScaleGestureDetector(SimpleScaleGestureListener simpleScaleGestureListener) {
        this.mListener = simpleScaleGestureListener;
        this.mPointerInfo = new LinkedList();
    }

    public void onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction() & 0xFF) {
            case 0: {
                if (this.getPointersDown() > 0) {
                    this.onTouchEnd(motionEvent);
                }
                this.onTouchStart(motionEvent);
                break;
            }
            case 5: {
                this.onTouchStart(motionEvent);
                break;
            }
            case 2: {
                this.onTouchMove(motionEvent);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                this.onTouchEnd(motionEvent);
            }
        }
    }

    private int getPointersDown() {
        return this.mPointerInfo.size();
    }

    private int getActionIndex(MotionEvent motionEvent) {
        return (motionEvent.getAction() & 0xFF00) >> 8;
    }

    private void onTouchStart(MotionEvent motionEvent) {
        this.mLastEventTime = motionEvent.getEventTime();
        this.mPointerInfo.addFirst(PointerInfo.create(motionEvent, this.getActionIndex(motionEvent)));
        if (this.getPointersDown() == 2) {
            this.sendScaleGesture(EventType.BEGIN);
        }
    }

    private void onTouchMove(MotionEvent motionEvent) {
        this.mLastEventTime = motionEvent.getEventTime();
        for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
            PointerInfo pointerInfo = this.pointerInfoForEventIndex(motionEvent, i);
            if (pointerInfo == null) continue;
            pointerInfo.populate(motionEvent, i);
        }
        if (this.getPointersDown() == 2) {
            this.sendScaleGesture(EventType.CONTINUE);
        }
    }

    private void onTouchEnd(MotionEvent motionEvent) {
        this.mLastEventTime = motionEvent.getEventTime();
        int n = motionEvent.getAction() & 0xFF;
        boolean bl = n == 3 || n == 0;
        int n2 = motionEvent.getPointerId(this.getActionIndex(motionEvent));
        ListIterator listIterator = this.mPointerInfo.listIterator();
        while (listIterator.hasNext()) {
            PointerInfo pointerInfo = (PointerInfo)listIterator.next();
            if (!bl && pointerInfo.getId() != n2) continue;
            listIterator.remove();
            pointerInfo.recycle();
            if (this.getPointersDown() != 1) continue;
            this.sendScaleGesture(EventType.END);
        }
    }

    public float getFocusX() {
        switch (this.getPointersDown()) {
            case 1: {
                return this.mPointerInfo.getFirst().getCurrent().x;
            }
            case 2: {
                PointerInfo pointerInfo = this.mPointerInfo.getFirst();
                PointerInfo pointerInfo2 = this.mPointerInfo.getLast();
                return (pointerInfo.getCurrent().x + pointerInfo2.getCurrent().x) / 2.0f;
            }
        }
        Log.e((String)LOGTAG, (String)"No gesture taking place in getFocusX()!");
        return 0.0f;
    }

    public float getFocusY() {
        switch (this.getPointersDown()) {
            case 1: {
                return this.mPointerInfo.getFirst().getCurrent().y;
            }
            case 2: {
                PointerInfo pointerInfo = this.mPointerInfo.getFirst();
                PointerInfo pointerInfo2 = this.mPointerInfo.getLast();
                return (pointerInfo.getCurrent().y + pointerInfo2.getCurrent().y) / 2.0f;
            }
        }
        Log.e((String)LOGTAG, (String)"No gesture taking place in getFocusY()!");
        return 0.0f;
    }

    public float getCurrentSpan() {
        if (this.getPointersDown() != 2) {
            Log.e((String)LOGTAG, (String)"No gesture taking place in getCurrentSpan()!");
            return 0.0f;
        }
        PointerInfo pointerInfo = this.mPointerInfo.getFirst();
        PointerInfo pointerInfo2 = this.mPointerInfo.getLast();
        return PointUtils.distance(pointerInfo.getCurrent(), pointerInfo2.getCurrent());
    }

    public float getPreviousSpan() {
        if (this.getPointersDown() != 2) {
            Log.e((String)LOGTAG, (String)"No gesture taking place in getPreviousSpan()!");
            return 0.0f;
        }
        PointerInfo pointerInfo = this.mPointerInfo.getFirst();
        PointerInfo pointerInfo2 = this.mPointerInfo.getLast();
        PointF pointF = pointerInfo.getPrevious();
        PointF pointF2 = pointerInfo2.getPrevious();
        if (pointF == null || pointF2 == null) {
            pointF = pointerInfo.getCurrent();
            pointF2 = pointerInfo2.getCurrent();
        }
        return PointUtils.distance(pointF, pointF2);
    }

    public long getEventTime() {
        return this.mLastEventTime;
    }

    public boolean isInProgress() {
        return this.getPointersDown() == 2;
    }

    private void sendScaleGesture(EventType eventType) {
        switch (eventType) {
            case BEGIN: {
                this.mScaleResult = this.mListener.onScaleBegin(this);
                break;
            }
            case CONTINUE: {
                if (!this.mScaleResult) break;
                this.mListener.onScale(this);
                break;
            }
            case END: {
                if (!this.mScaleResult) break;
                this.mListener.onScaleEnd(this);
            }
        }
    }

    private PointerInfo pointerInfoForEventIndex(MotionEvent motionEvent, int n) {
        int n2 = motionEvent.getPointerId(n);
        for (PointerInfo pointerInfo : this.mPointerInfo) {
            if (pointerInfo.getId() != n2) continue;
            return pointerInfo;
        }
        return null;
    }

    public static interface SimpleScaleGestureListener {
        public boolean onScale(SimpleScaleGestureDetector var1);

        public boolean onScaleBegin(SimpleScaleGestureDetector var1);

        public void onScaleEnd(SimpleScaleGestureDetector var1);
    }

    private static class PointerInfo {
        private static Stack<PointerInfo> sPointerInfoFreeList;
        private int mId;
        private PointF mCurrent;
        private PointF mPrevious;

        private PointerInfo() {
        }

        public static PointerInfo create(MotionEvent motionEvent, int n) {
            if (sPointerInfoFreeList == null) {
                sPointerInfoFreeList = new Stack();
            }
            PointerInfo pointerInfo = sPointerInfoFreeList.empty() ? new PointerInfo() : sPointerInfoFreeList.pop();
            pointerInfo.populate(motionEvent, n);
            return pointerInfo;
        }

        public void populate(MotionEvent motionEvent, int n) {
            this.mId = motionEvent.getPointerId(n);
            this.mPrevious = this.mCurrent;
            this.mCurrent = new PointF(motionEvent.getX(n), motionEvent.getY(n));
        }

        public void recycle() {
            this.mId = -1;
            this.mCurrent = null;
            this.mPrevious = null;
            sPointerInfoFreeList.push(this);
        }

        public int getId() {
            return this.mId;
        }

        public PointF getCurrent() {
            return this.mCurrent;
        }

        public PointF getPrevious() {
            return this.mPrevious;
        }

        public String toString() {
            if (this.mId == -1) {
                return "(up)";
            }
            try {
                String string2 = this.mPrevious == null ? "n/a" : PointUtils.toJSON(this.mPrevious).toString();
                String string3 = PointUtils.toJSON(this.mCurrent).toString();
                return "id=" + this.mId + " cur=" + string3 + " prev=" + string2;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
    }

    private static enum EventType {
        BEGIN,
        CONTINUE,
        END;

    }
}

