/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.health;

import android.content.ContentProviderClient;
import android.content.Context;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.background.healthreport.AndroidConfigurationProvider;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportGenerator;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class BrowserHealthReporter
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoHealthRep";
    public static final String EVENT_REQUEST = "HealthReport:Request";
    public static final String EVENT_RESPONSE = "HealthReport:Response";
    protected final Context context;

    public BrowserHealthReporter() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, EVENT_REQUEST);
        this.context = GeckoAppShell.getContext();
        if (this.context == null) {
            throw new IllegalStateException("Null Gecko context");
        }
    }

    public void uninit() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, EVENT_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject generateReport(long l, long l2, String string2) throws JSONException {
        ContentProviderClient contentProviderClient = EnvironmentBuilder.getContentProviderClient(this.context);
        if (contentProviderClient == null) {
            throw new IllegalStateException("Could not fetch Health Report content provider.");
        }
        try {
            HealthReportDatabaseStorage healthReportDatabaseStorage = EnvironmentBuilder.getStorage(contentProviderClient, string2);
            if (healthReportDatabaseStorage == null) {
                throw new IllegalStateException("No storage in Health Reporter.");
            }
            HealthReportGenerator healthReportGenerator = new HealthReportGenerator(healthReportDatabaseStorage);
            AndroidConfigurationProvider androidConfigurationProvider = new AndroidConfigurationProvider(this.context);
            JSONObject jSONObject = healthReportGenerator.generateDocument(l, l2, string2, androidConfigurationProvider);
            if (jSONObject == null) {
                throw new IllegalStateException("Not enough profile information to generate report.");
            }
            JSONObject jSONObject2 = jSONObject;
            return jSONObject2;
        }
        finally {
            contentProviderClient.release();
        }
    }

    protected long getLastUploadLocalTime() {
        return this.context.getSharedPreferences("background", 0).getLong("healthreport_last_upload_local_time", 0L);
    }

    public JSONObject generateReport() throws JSONException {
        GeckoProfile geckoProfile = GeckoAppShell.getGeckoInterface().getProfile();
        String string2 = geckoProfile.getDir().getAbsolutePath();
        long l = System.currentTimeMillis() - 15552000000L;
        long l2 = Math.max(this.getLastUploadLocalTime(), 1367500000000L);
        return this.generateReport(l, l2, string2);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    JSONObject jSONObject = null;
                    try {
                        jSONObject = BrowserHealthReporter.this.generateReport();
                    }
                    catch (Exception exception) {
                        Log.e((String)BrowserHealthReporter.LOGTAG, (String)"Generating report failed; responding with empty report.", (Throwable)exception);
                        jSONObject = new JSONObject();
                    }
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(BrowserHealthReporter.EVENT_RESPONSE, jSONObject.toString()));
                }
            });
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }
}

