/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.ReadingListRow;
import org.mozilla.gecko.home.SimpleCursorLoader;

public class ReadingListPanel
extends HomeFragment {
    private static final int LOADER_ID_READING_LIST = 0;
    private final String MATCH_STRING = "%I";
    private ReadingListAdapter mAdapter;
    private HomeListView mList;
    private View mEmptyView;
    private View mTopView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_reading_list_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mTopView = view;
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mList.setTag("reading_list");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                Cursor cursor = ReadingListPanel.this.mAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                string2 = ReaderModeUtils.getAboutReaderForUrl(string2);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM);
                ReadingListPanel.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

            @Override
            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                homeContextMenuInfo.readingListItemId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                homeContextMenuInfo.itemType = HomeContextMenuInfo.RemoveItemType.READING_LIST;
                return homeContextMenuInfo;
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mTopView = null;
        this.mEmptyView = null;
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new ReadingListAdapter((Context)this.getActivity(), null);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if ((cursor == null || cursor.getCount() == 0) && this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.mTopView.findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_hint);
            String string2 = textView.getText().toString();
            int n = string2.indexOf("%I");
            if (n != -1) {
                ImageSpan imageSpan = new ImageSpan((Context)this.getActivity(), R.drawable.reader_cropped, 0);
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
                spannableStringBuilder.insert(n + "%I".length(), (CharSequence)" ");
                spannableStringBuilder.insert(n, (CharSequence)" ");
                spannableStringBuilder.setSpan((Object)imageSpan, n + 1, n + "%I".length() + 1, 18);
                textView.setText((CharSequence)spannableStringBuilder, TextView.BufferType.SPANNABLE);
            }
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new ReadingListLoader((Context)ReadingListPanel.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            ReadingListPanel.this.mAdapter.swapCursor(cursor);
            ReadingListPanel.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            ReadingListPanel.this.mAdapter.swapCursor(null);
        }
    }

    private class ReadingListAdapter
    extends CursorAdapter {
        public ReadingListAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ReadingListRow readingListRow = (ReadingListRow)view;
            readingListRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.reading_list_item_row, viewGroup, false);
        }
    }

    private static class ReadingListLoader
    extends SimpleCursorLoader {
        public ReadingListLoader(Context context) {
            super(context);
        }

        @Override
        public Cursor loadCursor() {
            return BrowserDB.getReadingList(this.getContext().getContentResolver());
        }
    }
}

