/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;

public class ReadingListRow
extends LinearLayout {
    private final Resources resources;
    private final TextView title;
    private final TextView excerpt;
    private final TextView readTime;
    private static final int AVERAGE_READING_SPEED = 250;
    private static final float AVERAGE_WORD_LENGTH = 5.1f;

    public ReadingListRow(Context context) {
        this(context, null);
    }

    public ReadingListRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.reading_list_row_view, (ViewGroup)this);
        this.setOrientation(1);
        this.resources = context.getResources();
        this.title = (TextView)this.findViewById(R.id.title);
        this.excerpt = (TextView)this.findViewById(R.id.excerpt);
        this.readTime = (TextView)this.findViewById(R.id.read_time);
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        int n = cursor.getColumnIndexOrThrow("title");
        this.title.setText((CharSequence)cursor.getString(n));
        int n2 = cursor.getColumnIndexOrThrow("excerpt");
        this.excerpt.setText((CharSequence)cursor.getString(n2));
        int n3 = cursor.getColumnIndexOrThrow("length");
        int n4 = ReadingListRow.getEstimatedReadTime(cursor.getInt(n3));
        if (n4 <= 60) {
            this.readTime.setText((CharSequence)this.resources.getString(R.string.reading_list_time_minutes, new Object[]{n4}));
        } else {
            this.readTime.setText((CharSequence)this.resources.getString(R.string.reading_list_time_over_an_hour));
        }
    }

    private static int getEstimatedReadTime(int n) {
        int n2 = (int)Math.ceil((float)n / 5.1f / 250.0f);
        return Math.max(n2, 1);
    }
}

