/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.SharedPreferences;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.gecko.util.PrefUtils;

public class RemoteTabsExpandableListState {
    private static final String PREF_COLLAPSED_CLIENT_GUIDS = "remote_tabs_collapsed_client_guids";
    private static final String PREF_HIDDEN_CLIENT_GUIDS = "remote_tabs_hidden_client_guids";
    protected final SharedPreferences sharedPrefs;
    protected final Set<String> collapsedClients;
    protected final Set<String> hiddenClients;

    public RemoteTabsExpandableListState(SharedPreferences sharedPreferences) {
        if (null == sharedPreferences) {
            throw new IllegalArgumentException("sharedPrefs must not be null");
        }
        this.sharedPrefs = sharedPreferences;
        this.collapsedClients = this.getStringSet(PREF_COLLAPSED_CLIENT_GUIDS);
        this.hiddenClients = this.getStringSet(PREF_HIDDEN_CLIENT_GUIDS);
    }

    protected Set<String> getStringSet(String string2) {
        Set set = PrefUtils.getStringSet((SharedPreferences)this.sharedPrefs, (String)string2, null);
        if (set != null) {
            return new HashSet<String>(set);
        }
        return new HashSet<String>();
    }

    protected boolean updateClientMembership(String string2, Set<String> set, String string3, boolean bl) {
        boolean bl2 = bl ? set.add(string3) : set.remove(string3);
        if (bl2) {
            SharedPreferences.Editor editor = this.sharedPrefs.edit();
            PrefUtils.putStringSet((SharedPreferences.Editor)editor, (String)string2, set);
            editor.apply();
        }
        return bl2;
    }

    protected synchronized boolean setClientCollapsed(String string2, boolean bl) {
        return this.updateClientMembership(PREF_COLLAPSED_CLIENT_GUIDS, this.collapsedClients, string2, bl);
    }

    public synchronized boolean isClientCollapsed(String string2) {
        return this.collapsedClients.contains(string2);
    }

    protected synchronized boolean setClientHidden(String string2, boolean bl) {
        return this.updateClientMembership(PREF_HIDDEN_CLIENT_GUIDS, this.hiddenClients, string2, bl);
    }

    public synchronized boolean isClientHidden(String string2) {
        return this.hiddenClients.contains(string2);
    }
}

