/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;

abstract class SimpleCursorLoader
extends AsyncTaskLoader<Cursor> {
    final Loader.ForceLoadContentObserver mObserver = new Loader.ForceLoadContentObserver((Loader)this);
    Cursor mCursor;

    public SimpleCursorLoader(Context context) {
        super(context);
    }

    protected abstract Cursor loadCursor();

    public Cursor loadInBackground() {
        Cursor cursor = this.loadCursor();
        if (cursor != null) {
            cursor.getCount();
            cursor.registerContentObserver((ContentObserver)this.mObserver);
        }
        return cursor;
    }

    public void deliverResult(Cursor cursor) {
        if (this.isReset()) {
            if (cursor != null) {
                cursor.close();
            }
            return;
        }
        Cursor cursor2 = this.mCursor;
        this.mCursor = cursor;
        if (this.isStarted()) {
            super.deliverResult((Object)cursor);
        }
        if (cursor2 != null && cursor2 != cursor && !cursor2.isClosed()) {
            cursor2.close();
        }
    }

    protected void onStartLoading() {
        if (this.mCursor != null) {
            this.deliverResult(this.mCursor);
        }
        if (this.takeContentChanged() || this.mCursor == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.mCursor != null && !this.mCursor.isClosed()) {
            this.mCursor.close();
        }
        this.mCursor = null;
    }
}

