/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.preferences.MultiPrefMultiChoicePreference;

class PrivateDataPreference
extends MultiPrefMultiChoicePreference {
    private static final String LOGTAG = "GeckoPrivateDataPreference";
    private static final String PREF_KEY_PREFIX = "private.data.";

    public PrivateDataPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            return;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.SANITIZE, TelemetryContract.Method.DIALOG, "settings");
        Set<String> set = this.getValues();
        JSONObject jSONObject = new JSONObject();
        for (String string2 : set) {
            String string3 = string2.substring(PREF_KEY_PREFIX.length());
            try {
                jSONObject.put(string3, true);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
            }
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Sanitize:ClearData", jSONObject.toString()));
    }
}

