/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.prompts.PromptInput;

public class IconGridInput
extends PromptInput
implements AdapterView.OnItemClickListener {
    public static final String INPUT_TYPE = "icongrid";
    public static final String LOGTAG = "GeckoIconGridInput";
    private ArrayAdapter<IconGridItem> mAdapter;
    private static int mColumnWidth = -1;
    private static int mMaxColumns = -1;
    private static int mIconSize = -1;
    private int mSelected;
    private final JSONArray mArray;

    public IconGridInput(JSONObject jSONObject) {
        super(jSONObject);
        this.mArray = jSONObject.optJSONArray("items");
    }

    @Override
    public View getView(Context context) throws UnsupportedOperationException {
        if (mColumnWidth < 0) {
            mColumnWidth = context.getResources().getDimensionPixelSize(R.dimen.icongrid_columnwidth);
        }
        if (mIconSize < 0) {
            mIconSize = GeckoAppShell.getPreferredIconSize();
        }
        if (mMaxColumns < 0) {
            mMaxColumns = context.getResources().getInteger(R.integer.max_icon_grid_columns);
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int n = display.getWidth();
        int n2 = Math.min(mMaxColumns, n / mColumnWidth);
        GridView gridView = (GridView)LayoutInflater.from((Context)context).inflate(R.layout.icon_grid, null, false);
        gridView.setColumnWidth(mColumnWidth);
        ArrayList<IconGridItem> arrayList = new ArrayList<IconGridItem>(this.mArray.length());
        for (int i = 0; i < this.mArray.length(); ++i) {
            IconGridItem iconGridItem = new IconGridItem(context, this.mArray.optJSONObject(i));
            arrayList.add(iconGridItem);
            if (!iconGridItem.selected) continue;
            this.mSelected = i;
        }
        gridView.setNumColumns(Math.min(arrayList.size(), n2));
        gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        if (AppConstants.Versions.feature11Plus && this.mSelected > -1) {
            gridView.setItemChecked(this.mSelected, true);
        }
        this.mAdapter = new IconGridAdapter(context, -1, arrayList);
        gridView.setAdapter(this.mAdapter);
        this.mView = gridView;
        return this.mView;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        this.mSelected = n;
        this.notifyListeners(Integer.toString(n));
    }

    @Override
    public Object getValue() {
        return this.mSelected;
    }

    @Override
    public boolean getScrollable() {
        return true;
    }

    private class IconGridItem {
        final String label;
        final String description;
        final boolean selected;
        Drawable icon;

        public IconGridItem(Context context, JSONObject jSONObject) {
            this.label = jSONObject.optString("name");
            String string2 = jSONObject.optString("iconUri");
            this.description = jSONObject.optString("description");
            this.selected = jSONObject.optBoolean("selected");
            BitmapUtils.getDrawable(context, string2, new BitmapUtils.BitmapLoader(){

                @Override
                public void onBitmapFound(Drawable drawable2) {
                    IconGridItem.this.icon = drawable2;
                    if (IconGridInput.this.mAdapter != null) {
                        IconGridInput.this.mAdapter.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    private class IconGridAdapter
    extends ArrayAdapter<IconGridItem> {
        public IconGridAdapter(Context context, int n, List<IconGridItem> list) {
            super(context, n, list);
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            Context context = viewGroup.getContext();
            if (view == null) {
                view = LayoutInflater.from((Context)context).inflate(R.layout.icon_grid_item, viewGroup, false);
            }
            this.bindView(view, context, n);
            return view;
        }

        private void bindView(View view, Context context, int n) {
            IconGridItem iconGridItem = (IconGridItem)this.getItem(n);
            TextView textView = (TextView)view.findViewById(16908308);
            textView.setText((CharSequence)iconGridItem.label);
            TextView textView2 = (TextView)view.findViewById(16908309);
            if (TextUtils.isEmpty((CharSequence)iconGridItem.description)) {
                textView2.setVisibility(8);
            } else {
                textView2.setVisibility(0);
                textView2.setText((CharSequence)iconGridItem.description);
            }
            ImageView imageView = (ImageView)view.findViewById(R.id.icon);
            imageView.setImageDrawable(iconGridItem.icon);
            ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
            layoutParams.width = layoutParams.height = mIconSize;
        }
    }
}

