/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SyncResult;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.SyncException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class HTTPFailureException
extends SyncException {
    private static final long serialVersionUID = -5415864029780770619L;
    public SyncStorageResponse response;

    public HTTPFailureException(SyncStorageResponse syncStorageResponse) {
        this.response = syncStorageResponse;
    }

    @Override
    public String toString() {
        String string2;
        try {
            string2 = this.response.getErrorMessage();
        }
        catch (Exception exception) {
            string2 = "[unknown error message]";
        }
        return "<HTTPFailureException " + this.response.getStatusCode() + " :: (" + string2 + ")>";
    }

    @Override
    public void updateStats(GlobalSession globalSession, SyncResult syncResult) {
        switch (this.response.getStatusCode()) {
            case 401: {
                ++syncResult.stats.numAuthExceptions;
                return;
            }
            case 500: 
            case 501: 
            case 503: {
                ++syncResult.stats.numIoExceptions;
                return;
            }
        }
    }
}

