/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake;

import ch.boye.httpclientandroidlib.entity.StringEntity;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Queue;
import org.json.simple.JSONObject;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.CryptoInfo;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.crypto.NoKeyBundleException;
import org.mozilla.gecko.sync.jpake.JPakeNoActivePairingException;
import org.mozilla.gecko.sync.jpake.JPakeNumGenerator;
import org.mozilla.gecko.sync.jpake.JPakeNumGeneratorRandom;
import org.mozilla.gecko.sync.jpake.JPakeParty;
import org.mozilla.gecko.sync.jpake.stage.CompleteStage;
import org.mozilla.gecko.sync.jpake.stage.ComputeFinalStage;
import org.mozilla.gecko.sync.jpake.stage.ComputeKeyVerificationStage;
import org.mozilla.gecko.sync.jpake.stage.ComputeStepOneStage;
import org.mozilla.gecko.sync.jpake.stage.ComputeStepTwoStage;
import org.mozilla.gecko.sync.jpake.stage.DecryptDataStage;
import org.mozilla.gecko.sync.jpake.stage.DeleteChannel;
import org.mozilla.gecko.sync.jpake.stage.GetChannelStage;
import org.mozilla.gecko.sync.jpake.stage.GetRequestStage;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;
import org.mozilla.gecko.sync.jpake.stage.PutRequestStage;
import org.mozilla.gecko.sync.jpake.stage.VerifyPairingStage;
import org.mozilla.gecko.sync.setup.activities.SetupSyncActivity;

public class JPakeClient {
    private static final String LOG_TAG = "JPakeClient";
    public static final int REQUEST_TIMEOUT = 60000;
    public static final int KEYEXCHANGE_VERSION = 3;
    public static final String JPAKE_VERIFY_VALUE = "0123456789ABCDEF";
    private static final String JPAKE_SIGNERID_SENDER = "sender";
    private static final String JPAKE_SIGNERID_RECEIVER = "receiver";
    private static final int JPAKE_LENGTH_SECRET = 8;
    private static final int JPAKE_LENGTH_CLIENTID = 256;
    private static final int MAX_TRIES = 10;
    private static final int MAX_TRIES_FIRST_MSG = 300;
    private static final int MAX_TRIES_LAST_MSG = 300;
    public String clientId;
    public String secret;
    public String myEtag;
    public String mySignerId;
    public String theirEtag;
    public String theirSignerId;
    public String jpakeServer;
    public boolean paired;
    public boolean finished;
    public int jpakePollInterval;
    public int jpakeMaxTries;
    public String channel;
    public volatile String channelUrl;
    public KeyBundle myKeyBundle;
    public JSONObject jCreds;
    public ExtendedJSONObject jOutgoing;
    public ExtendedJSONObject jIncoming;
    public JPakeParty jParty;
    public JPakeNumGenerator numGen;
    public int pollTries;
    private final SetupSyncActivity controllerActivity;
    private Queue<JPakeStage> stages;

    public JPakeClient(SetupSyncActivity setupSyncActivity) {
        this.controllerActivity = setupSyncActivity;
        this.jpakeServer = "https://setup.services.mozilla.com/";
        this.jpakePollInterval = 1000;
        this.jpakeMaxTries = 10;
        if (!this.jpakeServer.endsWith("/")) {
            this.jpakeServer = this.jpakeServer + "/";
        }
        this.setClientId();
        this.numGen = new JPakeNumGeneratorRandom();
    }

    private void prepareSenderStages() {
        LinkedList<JPakeStage> linkedList = new LinkedList<JPakeStage>();
        linkedList.add(new ComputeStepOneStage());
        linkedList.add(new GetRequestStage());
        linkedList.add(new PutRequestStage());
        linkedList.add(new ComputeStepTwoStage());
        linkedList.add(new GetRequestStage());
        linkedList.add(new PutRequestStage());
        linkedList.add(new ComputeFinalStage());
        linkedList.add(new GetRequestStage());
        linkedList.add(new VerifyPairingStage());
        this.stages = linkedList;
    }

    private void prepareReceiverStages() {
        LinkedList<JPakeStage> linkedList = new LinkedList<JPakeStage>();
        linkedList.add(new GetChannelStage());
        linkedList.add(new ComputeStepOneStage());
        linkedList.add(new PutRequestStage());
        linkedList.add(new GetRequestStage());
        linkedList.add(new JPakeStage(){

            @Override
            public void execute(JPakeClient jPakeClient) {
                jPakeClient.onPairingStart();
                jPakeClient.jpakeMaxTries = 10;
                jPakeClient.runNextStage();
            }
        });
        linkedList.add(new ComputeStepTwoStage());
        linkedList.add(new PutRequestStage());
        linkedList.add(new GetRequestStage());
        linkedList.add(new ComputeFinalStage());
        linkedList.add(new ComputeKeyVerificationStage());
        linkedList.add(new PutRequestStage());
        linkedList.add(new JPakeStage(){

            @Override
            public void execute(JPakeClient jPakeClient) {
                JPakeClient.this.jpakeMaxTries = 300;
                jPakeClient.runNextStage();
            }
        });
        linkedList.add(new GetRequestStage());
        linkedList.add(new DecryptDataStage());
        linkedList.add(new CompleteStage());
        this.stages = linkedList;
    }

    public void pairWithPin(String string2) {
        this.mySignerId = JPAKE_SIGNERID_SENDER;
        this.theirSignerId = JPAKE_SIGNERID_RECEIVER;
        this.jParty = new JPakeParty(this.mySignerId);
        this.secret = string2.substring(0, 8);
        this.channel = string2.substring(8);
        this.channelUrl = this.jpakeServer + this.channel;
        this.prepareSenderStages();
        this.runNextStage();
    }

    public void receiveNoPin() {
        this.mySignerId = JPAKE_SIGNERID_RECEIVER;
        this.theirSignerId = JPAKE_SIGNERID_SENDER;
        this.jParty = new JPakeParty(this.mySignerId);
        this.jpakeMaxTries = 300;
        this.createSecret();
        this.prepareReceiverStages();
        this.runNextStage();
    }

    public void runNextStage() {
        if (this.finished || this.stages.size() == 0) {
            Logger.debug(LOG_TAG, "All stages complete.");
            return;
        }
        JPakeStage jPakeStage = null;
        try {
            jPakeStage = this.stages.remove();
            Logger.debug(LOG_TAG, "starting stage " + jPakeStage.toString());
            jPakeStage.execute(this);
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Exception in stage " + jPakeStage, exception);
            this.abort("Stage exception.");
        }
    }

    public void abort(String string2) {
        this.finished = true;
        if ("jpake.error.channel".equals(string2) || "jpake.error.network".equals(string2) || "jpake.error.nodata".equals(string2) || this.channelUrl == null) {
            this.displayAbort(string2);
        } else {
            new DeleteChannel().execute(this, string2);
        }
    }

    public void displayAbort(String string2) {
        this.controllerActivity.displayAbort(string2);
    }

    public static void runOnThread(Runnable runnable) {
        ThreadPool.run(runnable);
    }

    public static BigInteger secretAsBigInteger(String string2) throws UnsupportedEncodingException {
        return new BigInteger(string2.getBytes("UTF-8"));
    }

    public static ExtendedJSONObject encryptPayload(String string2, KeyBundle keyBundle, boolean bl) throws UnsupportedEncodingException, CryptoException {
        if (keyBundle == null) {
            throw new NoKeyBundleException();
        }
        byte[] byArray = string2.getBytes("UTF-8");
        CryptoInfo cryptoInfo = CryptoInfo.encrypt(byArray, keyBundle);
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        String string3 = new String(Base64.encodeBase64((byte[])cryptoInfo.getMessage()));
        String string4 = new String(Base64.encodeBase64((byte[])cryptoInfo.getIV()));
        extendedJSONObject.put("ciphertext", string3);
        extendedJSONObject.put("IV", string4);
        if (bl) {
            String string5 = Utils.byte2Hex(cryptoInfo.getHMAC());
            extendedJSONObject.put("hmac", string5);
        }
        return extendedJSONObject;
    }

    public static StringEntity jsonEntity(JSONObject jSONObject) throws UnsupportedEncodingException {
        StringEntity stringEntity = new StringEntity(jSONObject.toJSONString(), "UTF-8");
        stringEntity.setContentType("application/json");
        return stringEntity;
    }

    public void makeAndDisplayPin(String string2) {
        this.controllerActivity.displayPin(this.secret + string2);
    }

    public void onPairingStart() {
        Logger.debug(LOG_TAG, "Pairing started.");
        this.controllerActivity.onPairingStart();
    }

    public void onPaired() {
        Logger.debug(LOG_TAG, "Pairing completed. Starting credential exchange.");
        this.controllerActivity.onPaired();
    }

    public void complete(JSONObject jSONObject) {
        this.controllerActivity.onComplete(jSONObject);
    }

    public void sendAndComplete(JSONObject jSONObject) throws JPakeNoActivePairingException {
        if (!this.paired || this.finished) {
            Logger.error(LOG_TAG, "Can't send data, no active pairing!");
            throw new JPakeNoActivePairingException();
        }
        this.stages.clear();
        this.stages.add(new PutRequestStage());
        this.stages.add(new CompleteStage());
        String string2 = jSONObject.toJSONString();
        this.encryptData(this.myKeyBundle, string2);
        this.runNextStage();
    }

    private void setClientId() {
        byte[] byArray = Utils.generateRandomBytes(128);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string2 = Integer.toHexString(by);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            int n = string2.length();
            stringBuilder.append(string2.substring(n - 2, n));
        }
        this.clientId = stringBuilder.toString();
    }

    private void createSecret() {
        String string2 = "23456789abcdefghijkmnpqrstuvwxyz";
        int n = string2.length();
        byte[] byArray = Utils.generateRandomBytes(8);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(string2.charAt(Math.abs(by) * n / 256));
        }
        this.secret = stringBuilder.toString();
    }

    private void encryptData(KeyBundle keyBundle, String string2) {
        Logger.debug(LOG_TAG, "Encrypting data.");
        ExtendedJSONObject extendedJSONObject = null;
        try {
            extendedJSONObject = JPakeClient.encryptPayload(string2, keyBundle, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error(LOG_TAG, "Failed to encrypt data.", unsupportedEncodingException);
            this.abort("jpake.error.internal");
            return;
        }
        catch (CryptoException cryptoException) {
            Logger.error(LOG_TAG, "Failed to encrypt data.", cryptoException);
            this.abort("jpake.error.internal");
            return;
        }
        this.jOutgoing = new ExtendedJSONObject();
        this.jOutgoing.put("type", this.mySignerId + "3");
        this.jOutgoing.put("version", 3);
        this.jOutgoing.put("payload", extendedJSONObject.object);
    }
}

