/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.BaseResource;

public class ConnectionMonitorThread
extends Thread {
    private static final long REAP_INTERVAL = 5000L;
    private static final String LOG_TAG = "ConnectionMonitorThread";
    private volatile boolean stopping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.stopping) {
                ConnectionMonitorThread connectionMonitorThread = this;
                synchronized (connectionMonitorThread) {
                    this.wait(5000L);
                    BaseResource.closeExpiredConnections();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.trace(LOG_TAG, "Interrupted.");
        }
        BaseResource.shutdownConnectionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Logger.debug(LOG_TAG, "ConnectionMonitorThread told to shut down.");
        this.stopping = true;
        ConnectionMonitorThread connectionMonitorThread = this;
        synchronized (connectionMonitorThread) {
            this.notifyAll();
        }
    }
}

