/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.SyncStorageRequest;

public class SyncStorageRecordRequest
extends SyncStorageRequest {
    public SyncStorageRecordRequest(URI uRI) {
        super(uRI);
    }

    public SyncStorageRecordRequest(String string2) throws URISyntaxException {
        this(new URI(string2));
    }

    @Override
    protected BaseResourceDelegate makeResourceDelegate(SyncStorageRequest syncStorageRequest) {
        return new SyncStorageRecordResourceDelegate(syncStorageRequest);
    }

    public void post(JSONObject jSONObject) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)jSONObject);
        try {
            this.resource.post(jSONArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.delegate.handleRequestError(unsupportedEncodingException);
        }
    }

    public void post(JSONArray jSONArray) {
        try {
            this.resource.post(jSONArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.delegate.handleRequestError(unsupportedEncodingException);
        }
    }

    public void put(JSONObject jSONObject) {
        try {
            this.resource.put(jSONObject);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.delegate.handleRequestError(unsupportedEncodingException);
        }
    }

    public void post(CryptoRecord cryptoRecord) {
        this.post(cryptoRecord.toJSONObject());
    }

    public void put(CryptoRecord cryptoRecord) {
        this.put(cryptoRecord.toJSONObject());
    }

    public void deferGet() {
        final SyncStorageRecordRequest syncStorageRecordRequest = this;
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                syncStorageRecordRequest.get();
            }
        });
    }

    public void deferPut(final JSONObject jSONObject) {
        final SyncStorageRecordRequest syncStorageRecordRequest = this;
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                syncStorageRecordRequest.put(jSONObject);
            }
        });
    }

    public class SyncStorageRecordResourceDelegate
    extends SyncStorageRequest.SyncStorageResourceDelegate {
        SyncStorageRecordResourceDelegate(SyncStorageRequest syncStorageRequest) {
            super(SyncStorageRecordRequest.this, syncStorageRequest);
        }
    }
}

