/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import java.util.HashSet;
import java.util.Iterator;
import org.mozilla.gecko.sync.repositories.RecordFilter;
import org.mozilla.gecko.sync.repositories.StoreTracker;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class HashSetStoreTracker
implements StoreTracker {
    private final HashSet<String> guids = new HashSet();

    public String toString() {
        return "#<Tracker: " + this.guids.size() + " guids tracked.>";
    }

    @Override
    public synchronized boolean trackRecordForExclusion(String string2) {
        return string2 != null && this.guids.add(string2);
    }

    @Override
    public synchronized boolean isTrackedForExclusion(String string2) {
        return string2 != null && this.guids.contains(string2);
    }

    @Override
    public synchronized boolean untrackStoredForExclusion(String string2) {
        return string2 != null && this.guids.remove(string2);
    }

    @Override
    public RecordFilter getFilter() {
        if (this.guids.size() == 0) {
            return null;
        }
        return new RecordFilter(){

            @Override
            public boolean excludeRecord(Record record) {
                return HashSetStoreTracker.this.isTrackedForExclusion(record.guid);
            }
        };
    }

    @Override
    public Iterator<String> recordsTrackedForExclusion() {
        return this.guids.iterator();
    }
}

