/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.util.List;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.db.CursorDumper;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.Record;

public abstract class AndroidBrowserRepositoryDataAccessor {
    private static final String[] GUID_COLUMNS = new String[]{"guid"};
    protected Context context;
    protected static String LOG_TAG = "BrowserDataAccessor";
    protected final RepoUtils.QueryHelper queryHelper;

    public AndroidBrowserRepositoryDataAccessor(Context context) {
        this.context = context;
        this.queryHelper = new RepoUtils.QueryHelper(context, this.getUri(), LOG_TAG);
    }

    protected abstract String[] getAllColumns();

    protected abstract ContentValues getContentValues(Record var1);

    protected abstract Uri getUri();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDB() {
        try (Cursor cursor = null;){
            cursor = this.queryHelper.safeQuery(".dumpDB", null, null, null, null);
            CursorDumper.dumpCursor(cursor);
        }
    }

    public String dateModifiedWhere(long l) {
        return "modified >= " + Long.toString(l);
    }

    public void delete(String string2, String[] stringArray) {
        Uri uri = this.getUri();
        this.context.getContentResolver().delete(uri, string2, stringArray);
    }

    public void wipe() {
        Logger.debug(LOG_TAG, "Wiping.");
        this.delete(null, null);
    }

    public void purgeDeleted() throws NullCursorException {
        String string2 = "deleted= 1";
        Uri uri = this.getUri();
        Logger.info(LOG_TAG, "Purging deleted from: " + uri);
        this.context.getContentResolver().delete(uri, string2, null);
    }

    public int purgeGuid(String string2) {
        String string3 = "guid = ?";
        String[] stringArray = new String[]{string2};
        int n = this.context.getContentResolver().delete(this.getUri(), string3, stringArray);
        if (n != 1) {
            Logger.warn(LOG_TAG, "Unexpectedly deleted " + n + " records for guid " + string2);
        }
        return n;
    }

    public void update(String string2, Record record) {
        String string3 = "guid = ?";
        String[] stringArray = new String[]{string2};
        ContentValues contentValues = this.getContentValues(record);
        int n = this.context.getContentResolver().update(this.getUri(), contentValues, string3, stringArray);
        if (n != 1) {
            Logger.warn(LOG_TAG, "Unexpectedly updated " + n + " rows for guid " + string2);
        }
    }

    public Uri insert(Record record) {
        ContentValues contentValues = this.getContentValues(record);
        return this.context.getContentResolver().insert(this.getUri(), contentValues);
    }

    public Cursor fetchAll() throws NullCursorException {
        return this.queryHelper.safeQuery(".fetchAll", this.getAllColumns(), null, null, null);
    }

    public Cursor getGUIDsSince(long l) throws NullCursorException {
        return this.queryHelper.safeQuery(".getGUIDsSince", GUID_COLUMNS, this.dateModifiedWhere(l), null, null);
    }

    public Cursor fetchSince(long l) throws NullCursorException {
        return this.queryHelper.safeQuery(".fetchSince", this.getAllColumns(), this.dateModifiedWhere(l), null, null);
    }

    public Cursor fetch(String[] stringArray) throws NullCursorException {
        String string2 = RepoUtils.computeSQLInClause(stringArray.length, "guid");
        return this.queryHelper.safeQuery(".fetch", this.getAllColumns(), string2, stringArray, null);
    }

    public void updateByGuid(String string2, ContentValues contentValues) {
        String string3 = "guid = ?";
        String[] stringArray = new String[]{string2};
        int n = this.context.getContentResolver().update(this.getUri(), contentValues, string3, stringArray);
        if (n == 1) {
            return;
        }
        Logger.warn(LOG_TAG, "Unexpectedly updated " + n + " rows for guid " + string2);
    }

    public int bulkInsert(List<Record> list) throws NullCursorException {
        int n;
        if (list.isEmpty()) {
            Logger.debug(LOG_TAG, "No records to insert, returning.");
        }
        int n2 = list.size();
        ContentValues[] contentValuesArray = new ContentValues[n2];
        int n3 = 0;
        for (Record record : list) {
            try {
                contentValuesArray[n3] = this.getContentValues(record);
                ++n3;
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Got exception in getContentValues for record with guid " + record.guid, exception);
            }
        }
        if (n3 != n2) {
            n2 = n3;
            ContentValues[] contentValuesArray2 = new ContentValues[n2];
            System.arraycopy(contentValuesArray, 0, contentValuesArray2, 0, n2);
        }
        if ((n = this.context.getContentResolver().bulkInsert(this.getUri(), contentValuesArray)) == n2) {
            Logger.debug(LOG_TAG, "Inserted " + n + " records, as expected.");
        } else {
            Logger.debug(LOG_TAG, "Inserted " + n + " records but expected " + n2 + " records.");
        }
        return n;
    }
}

