/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;
import org.mozilla.gecko.sync.setup.activities.SendTabActivity;

public class ClientRecordArrayAdapter
extends ArrayAdapter<ClientRecord> {
    public static final String LOG_TAG = "ClientRecArrayAdapter";
    private boolean[] checkedItems = new boolean[0];
    private final SendTabActivity sendTabActivity;

    public ClientRecordArrayAdapter(Context context, int n) {
        super(context, n, new ArrayList());
        this.sendTabActivity = (SendTabActivity)context;
    }

    public synchronized void setClientRecordList(Collection<ClientRecord> collection) {
        this.clear();
        this.checkedItems = new boolean[collection.size()];
        for (ClientRecord clientRecord : collection) {
            this.add(clientRecord);
        }
        this.notifyDataSetChanged();
    }

    public synchronized void checkItem(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.checkedItems.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.setRowChecked(n, true)) {
            this.notifyDataSetChanged();
        }
    }

    protected synchronized boolean setRowChecked(int n, boolean bl) {
        boolean bl2 = this.checkedItems[n];
        if (bl2 == bl) {
            return false;
        }
        this.checkedItems[n] = bl;
        this.sendTabActivity.enableSend(this.getNumCheckedGUIDs() > 0);
        return true;
    }

    public View getView(final int n, View view, ViewGroup viewGroup) {
        Context context = this.getContext();
        View view2 = view;
        if (view2 == null) {
            view2 = View.inflate((Context)context, (int)R.layout.sync_list_item, null);
            this.setSelectable(view2, true);
            view2.setBackgroundResource(17301605);
        }
        ClientRecord clientRecord = (ClientRecord)this.getItem(n);
        ImageView imageView = (ImageView)view2.findViewById(R.id.img);
        TextView textView = (TextView)view2.findViewById(R.id.client_name);
        CheckBox checkBox = (CheckBox)view2.findViewById(R.id.check);
        checkBox.setChecked(this.checkedItems[n]);
        this.setSelectable((View)checkBox, false);
        textView.setText((CharSequence)clientRecord.name);
        imageView.setImageResource(this.getImage(clientRecord));
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CheckBox checkBox = (CheckBox)view.findViewById(R.id.check);
                boolean bl = !checkBox.isChecked();
                checkBox.setChecked(bl);
                ClientRecordArrayAdapter.this.setRowChecked(n, bl);
            }
        });
        return view2;
    }

    public synchronized List<String> getCheckedGUIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.checkedItems.length; ++i) {
            if (!this.checkedItems[i]) continue;
            arrayList.add(((ClientRecord)this.getItem((int)i)).guid);
        }
        return arrayList;
    }

    public synchronized int getNumCheckedGUIDs() {
        int n = 0;
        for (int i = 0; i < this.checkedItems.length; ++i) {
            if (!this.checkedItems[i]) continue;
            ++n;
        }
        return n;
    }

    private int getImage(ClientRecord clientRecord) {
        if ("mobile".equals(clientRecord.type)) {
            return R.drawable.sync_mobile;
        }
        return R.drawable.sync_desktop;
    }

    private void setSelectable(View view, boolean bl) {
        view.setClickable(bl);
        view.setFocusable(bl);
    }
}

