/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.MetaGlobal;
import org.mozilla.gecko.sync.PersistedMetaGlobal;
import org.mozilla.gecko.sync.delegates.MetaGlobalDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.stage.AbstractNonRepositorySyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

public class FetchMetaGlobalStage
extends AbstractNonRepositorySyncStage {
    private static final String LOG_TAG = "FetchMetaGlobalStage";
    private static final String META_COLLECTION = "meta";

    @Override
    public void execute() throws NoSuchStageException {
        MetaGlobal metaGlobal;
        InfoCollections infoCollections = this.session.config.infoCollections;
        if (infoCollections == null) {
            this.session.abort(null, "No info/collections set in FetchMetaGlobalStage.");
            return;
        }
        long l = this.session.config.persistedMetaGlobal().lastModified();
        if (!infoCollections.updateNeeded(META_COLLECTION, l)) {
            Logger.info(LOG_TAG, "Trying to use persisted meta/global for this session.");
            metaGlobal = this.session.config.persistedMetaGlobal().metaGlobal(this.session.config.metaURL(), this.session.getAuthHeaderProvider());
            if (metaGlobal != null) {
                Logger.info(LOG_TAG, "Using persisted meta/global for this session.");
                this.session.processMetaGlobal(metaGlobal);
                return;
            }
            Logger.info(LOG_TAG, "Failed to use persisted meta/global for this session.");
        }
        Logger.info(LOG_TAG, "Fetching fresh meta/global for this session.");
        metaGlobal = new MetaGlobal(this.session.config.metaURL(), this.session.getAuthHeaderProvider());
        metaGlobal.fetch(new StageMetaGlobalDelegate(this.session));
    }

    public class StageMetaGlobalDelegate
    implements MetaGlobalDelegate {
        private final GlobalSession session;

        public StageMetaGlobalDelegate(GlobalSession globalSession) {
            this.session = globalSession;
        }

        @Override
        public void handleSuccess(MetaGlobal metaGlobal, SyncStorageResponse syncStorageResponse) {
            Logger.trace(FetchMetaGlobalStage.LOG_TAG, "Persisting fetched meta/global and last modified.");
            PersistedMetaGlobal persistedMetaGlobal = this.session.config.persistedMetaGlobal();
            persistedMetaGlobal.persistMetaGlobal(metaGlobal);
            persistedMetaGlobal.persistLastModified(syncStorageResponse.normalizedWeaveTimestamp());
            this.session.processMetaGlobal(metaGlobal);
        }

        @Override
        public void handleFailure(SyncStorageResponse syncStorageResponse) {
            this.session.handleHTTPError(syncStorageResponse, "Failure fetching meta/global.");
        }

        @Override
        public void handleError(Exception exception) {
            this.session.abort(exception, "Failure fetching meta/global.");
        }

        @Override
        public void handleMissing(MetaGlobal metaGlobal, SyncStorageResponse syncStorageResponse) {
            this.session.processMissingMetaGlobal(metaGlobal);
        }
    }
}

