/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

public interface GlobalSyncStage {
    public void execute(GlobalSession var1) throws NoSuchStageException;

    public void resetLocal(GlobalSession var1);

    public void wipeLocal(GlobalSession var1) throws Exception;

    public Integer getStorageVersion();

    public static enum Stage {
        idle,
        checkPreconditions,
        ensureClusterURL,
        fetchInfoCollections,
        fetchMetaGlobal,
        ensureKeysStage,
        syncClientsEngine("clients"),
        syncTabs("tabs"),
        syncPasswords("passwords"),
        syncBookmarks("bookmarks"),
        syncHistory("history"),
        syncFormHistory("forms"),
        uploadMetaGlobal,
        completed;

        private static final Map<String, Stage> named;
        private final String repositoryName;

        public static Stage byName(String string2) {
            if (string2 == null) {
                return null;
            }
            return named.get(string2);
        }

        public static Collection<Stage> getNamedStages() {
            return Collections.unmodifiableCollection(named.values());
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        private Stage() {
            this.repositoryName = null;
        }

        private Stage(String string3) {
            this.repositoryName = string3;
        }

        static {
            named = new HashMap<String, Stage>();
            for (Stage stage : EnumSet.allOf(Stage.class)) {
                if (stage.getRepositoryName() == null) continue;
                named.put(stage.getRepositoryName(), stage);
            }
        }
    }
}

