/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.Locale;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabsPanel;

class PrivateTabsPanel
extends FrameLayout
implements TabsPanel.CloseAllPanelView {
    private TabsPanel tabsPanel;
    private final TabsPanel.TabsLayout tabsLayout;

    public PrivateTabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.private_tabs_panel, (ViewGroup)this);
        this.tabsLayout = (TabsPanel.TabsLayout)this.findViewById(R.id.private_tabs_tray);
        View view = this.findViewById(R.id.private_tabs_empty);
        this.tabsLayout.setEmptyView(view);
        View view2 = this.findViewById(R.id.private_tabs_learn_more);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = BrowserLocaleManager.getLanguageTag(Locale.getDefault());
                String string3 = PrivateTabsPanel.this.getResources().getString(R.string.private_tabs_panel_learn_more_link, new Object[]{string2});
                Tabs.getInstance().loadUrlInTab(string3);
                if (PrivateTabsPanel.this.tabsPanel != null) {
                    PrivateTabsPanel.this.tabsPanel.autoHidePanel();
                }
            }
        });
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
        this.tabsLayout.setTabsPanel(tabsPanel);
    }

    @Override
    public void show() {
        this.tabsLayout.show();
        this.setVisibility(0);
    }

    @Override
    public void hide() {
        this.setVisibility(8);
        this.tabsLayout.hide();
    }

    @Override
    public boolean shouldExpand() {
        return this.tabsLayout.shouldExpand();
    }

    @Override
    public void closeAll() {
        this.tabsLayout.closeAll();
    }
}

