/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.tabs.TabStripItemView;

class TabStripAdapter
extends BaseAdapter {
    private static final String LOGTAG = "GeckoTabStripAdapter";
    private final Context context;
    private List<Tab> tabs;

    public TabStripAdapter(Context context) {
        this.context = context;
    }

    public Tab getItem(int n) {
        return this.tabs != null && n >= 0 && n < this.tabs.size() ? this.tabs.get(n) : null;
    }

    public long getItemId(int n) {
        Tab tab = this.getItem(n);
        return tab != null ? tab.getId() : -1;
    }

    public boolean hasStableIds() {
        return true;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        TabStripItemView tabStripItemView = view == null ? (TabStripItemView)LayoutInflater.from((Context)this.context).inflate(R.layout.tab_strip_item, viewGroup, false) : (TabStripItemView)view;
        Tab tab = this.tabs.get(n);
        tabStripItemView.updateFromTab(tab);
        return tabStripItemView;
    }

    public int getCount() {
        return this.tabs != null ? this.tabs.size() : 0;
    }

    int getPositionForTab(Tab tab) {
        if (this.tabs == null || tab == null) {
            return -1;
        }
        return this.tabs.indexOf(tab);
    }

    void removeTab(Tab tab) {
        if (this.tabs == null) {
            return;
        }
        this.tabs.remove(tab);
        this.notifyDataSetChanged();
    }

    void refresh(List<Tab> list) {
        this.tabs = list;
        this.notifyDataSetChanged();
    }

    void clear() {
        this.tabs = null;
        this.notifyDataSetInvalidated();
    }
}

