/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbarPhoneBase;
import org.mozilla.gecko.util.HardwareUtils;

class BrowserToolbarPreHC
extends BrowserToolbarPhoneBase {
    public BrowserToolbarPreHC(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    public boolean isAnimating() {
        return false;
    }

    @Override
    protected void triggerStartEditingTransition(PropertyAnimator propertyAnimator) {
        this.showUrlEditLayout();
        this.updateEditingState(true);
    }

    @Override
    protected void triggerStopEditingTransition() {
        this.hideUrlEditLayout();
        this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
        this.updateEditingState(false);
    }

    private void updateEditingState(boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = this.getUrlBarCurveTranslation();
            n = this.getUrlBarEntryTranslation();
        } else {
            n2 = 0;
            n = 0;
        }
        this.tabsButton.setEnabled(!bl);
        ViewHelper.setTranslationX((View)this.urlBarTranslatingEdge, n);
        ViewHelper.setTranslationX((View)this.tabsButton, n2);
        ViewHelper.setTranslationX((View)this.tabsCounter, n2);
        if (!HardwareUtils.hasMenuButton()) {
            this.menuButton.setEnabled(!bl);
            ViewHelper.setTranslationX((View)this.menuButton, n2);
            ViewHelper.setTranslationX((View)this.menuIcon, n2);
        }
    }
}

