/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbarTabletBase;

class BrowserToolbarTablet
extends BrowserToolbarTabletBase {
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final RelativeLayout.LayoutParams urlBarEntryDefaultLayoutParams;
    private final RelativeLayout.LayoutParams urlBarEntryShrunkenLayoutParams;
    private List<View> tabletDisplayModeViews;
    private boolean hidForwardButtonOnStartEditing;
    private final int urlBarViewOffset;
    private final int defaultForwardMargin;
    private final Interpolator buttonsInterpolator = new AccelerateInterpolator();

    public BrowserToolbarTablet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.urlBarEntryDefaultLayoutParams = (RelativeLayout.LayoutParams)this.urlBarEntry.getLayoutParams();
        this.urlBarEntryShrunkenLayoutParams = new RelativeLayout.LayoutParams((ViewGroup.MarginLayoutParams)this.urlBarEntryDefaultLayoutParams);
        this.urlBarEntryShrunkenLayoutParams.addRule(7, R.id.edit_layout);
        this.urlBarEntryShrunkenLayoutParams.addRule(5, R.id.edit_layout);
        this.urlBarEntryShrunkenLayoutParams.leftMargin = 0;
        Resources resources = this.getResources();
        this.urlBarViewOffset = resources.getDimensionPixelSize(R.dimen.url_bar_offset_left);
        this.defaultForwardMargin = resources.getDimensionPixelSize(R.dimen.forward_default_offset);
    }

    private ArrayList<View> populateTabletViews() {
        View[] viewArray = new View[]{this.actionItemBar, this.backButton, this.menuButton, this.menuIcon, this.tabsButton, this.tabsCounter};
        ArrayList<View> arrayList = new ArrayList<View>(viewArray.length);
        for (View view : viewArray) {
            if (view.getVisibility() != 0) continue;
            arrayList.add(view);
        }
        return arrayList;
    }

    @Override
    public boolean isAnimating() {
        return false;
    }

    @Override
    protected void triggerStartEditingTransition(PropertyAnimator propertyAnimator) {
        if (this.tabletDisplayModeViews == null) {
            this.tabletDisplayModeViews = this.populateTabletViews();
        }
        this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)this.urlBarEntryShrunkenLayoutParams);
        this.updateChildrenState();
        for (View view : this.tabletDisplayModeViews) {
            view.setVisibility(4);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && tab.canDoForward()) {
            this.hidForwardButtonOnStartEditing = true;
            this.forwardButton.setVisibility(4);
        } else {
            this.hidForwardButtonOnStartEditing = false;
        }
        this.showUrlEditLayout();
    }

    @Override
    protected void triggerStopEditingTransition() {
        if (this.tabletDisplayModeViews == null) {
            throw new IllegalStateException("We initialize tabletDisplayModeViews in the transition to show editing mode and don't expect stop editing to be called first.");
        }
        this.urlBarEntry.setLayoutParams((ViewGroup.LayoutParams)this.urlBarEntryDefaultLayoutParams);
        this.updateChildrenState();
        for (View view : this.tabletDisplayModeViews) {
            view.setVisibility(0);
        }
        if (this.hidForwardButtonOnStartEditing) {
            this.forwardButton.setVisibility(0);
        }
        this.hideUrlEditLayout();
    }

    private void updateChildrenState() {
        boolean bl;
        boolean bl2 = bl = !this.isEditing();
        if (!bl) {
            this.tabsCounter.onEnterEditingMode();
        }
        this.tabsButton.setEnabled(bl);
        this.menuButton.setEnabled(bl);
        int n = this.actionItemBar.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.actionItemBar.getChildAt(i).setEnabled(bl);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            BrowserToolbarTablet.setButtonEnabled(this.backButton, this.canDoBack(tab));
            BrowserToolbarTablet.setButtonEnabled(this.forwardButton, this.canDoForward(tab));
            if (!this.isEditing()) {
                this.animateForwardButton(this.canDoForward(tab) ? BrowserToolbarTabletBase.ForwardButtonAnimation.SHOW : BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE);
            }
        }
    }

    @Override
    protected void animateForwardButton(BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation) {
        if (this.forwardButton.getVisibility() != 0) {
            return;
        }
        final boolean bl = forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.SHOW;
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.forwardButton.getLayoutParams();
        if (marginLayoutParams.leftMargin > this.defaultForwardMargin && bl || marginLayoutParams.leftMargin == this.defaultForwardMargin && !bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(this.isSwitchingTabs ? 10L : 450L);
        final int n = this.forwardButton.getWidth() / 2;
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbarTablet.this.requestLayout();
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                if (bl) {
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarTablet.this.urlBarViewOffset;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarTablet.this.urlBarViewOffset;
                }
                BrowserToolbarTablet.this.urlDisplayLayout.finishForwardAnimation();
                marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarTablet.this.forwardButton.getLayoutParams();
                marginLayoutParams.leftMargin = BrowserToolbarTablet.this.defaultForwardMargin + (bl ? n : 0);
                ViewHelper.setTranslationX((View)BrowserToolbarTablet.this.forwardButton, 0.0f);
                BrowserToolbarTablet.this.requestLayout();
            }
        });
        this.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
        propertyAnimator.start();
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 0.0f);
        } else {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        this.urlDisplayLayout.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
    }

    @Override
    public void triggerTabsPanelTransition(PropertyAnimator propertyAnimator, boolean bl) {
        if (bl) {
            ViewHelper.setAlpha((View)this.tabsCounter, 0.0f);
            return;
        }
        PropertyAnimator propertyAnimator2 = new PropertyAnimator(propertyAnimator.getDuration(), this.buttonsInterpolator);
        propertyAnimator2.attach((View)this.tabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator2.start();
    }
}

