/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.ImageView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;

public class FaviconView
extends ImageView {
    private Bitmap mIconBitmap;
    private Bitmap mUnscaledBitmap;
    private String mIconKey;
    private int mActualWidth;
    private int mActualHeight;
    private boolean mScalingExpected;
    private int mDominantColor;
    private static float sStrokeWidth;
    private static final Paint sStrokePaint;
    private static final Paint sBackgroundPaint;
    private final RectF mStrokeRect;
    private final RectF mBackgroundRect;

    public FaviconView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setScaleType(ImageView.ScaleType.CENTER);
        this.mStrokeRect = new RectF();
        this.mBackgroundRect = new RectF();
        if (sStrokeWidth == 0.0f) {
            sStrokeWidth = this.getResources().getDisplayMetrics().density;
            sStrokePaint.setStrokeWidth(sStrokeWidth);
        }
        this.mStrokeRect.left = this.mStrokeRect.top = sStrokeWidth;
        this.mBackgroundRect.left = this.mBackgroundRect.top = sStrokeWidth * 2.0f;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n == this.mActualWidth && n2 == this.mActualHeight) {
            return;
        }
        this.mActualWidth = n;
        this.mActualHeight = n2;
        this.mStrokeRect.right = (float)n - sStrokeWidth;
        this.mStrokeRect.bottom = (float)n2 - sStrokeWidth;
        this.mBackgroundRect.right = this.mStrokeRect.right - sStrokeWidth;
        this.mBackgroundRect.bottom = this.mStrokeRect.bottom - sStrokeWidth;
        this.formatImage();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        sBackgroundPaint.setColor(this.mDominantColor & 0x46FFFFFF);
        canvas.drawRect(this.mStrokeRect, sBackgroundPaint);
        sStrokePaint.setColor(this.mDominantColor);
        canvas.drawRoundRect(this.mStrokeRect, sStrokeWidth, sStrokeWidth, sStrokePaint);
    }

    private void formatImage() {
        if (this.mIconBitmap == null || this.mActualWidth == 0 || this.mActualHeight == 0) {
            this.showNoImage();
            return;
        }
        if (this.mScalingExpected && this.mActualWidth != this.mIconBitmap.getWidth()) {
            this.scaleBitmap();
            this.mScalingExpected = false;
        }
        this.setImageBitmap(this.mIconBitmap);
        if (Math.abs(this.mIconBitmap.getWidth() - this.mActualWidth) > 3) {
            this.mDominantColor = Favicons.getFaviconColor(this.mIconKey);
            if (this.mDominantColor == -1) {
                this.mDominantColor = 0;
            }
        } else {
            this.mDominantColor = 0;
        }
    }

    private void scaleBitmap() {
        int n = this.mIconBitmap.getWidth() * 2;
        this.mIconBitmap = this.mActualWidth > n ? Bitmap.createScaledBitmap((Bitmap)this.mIconBitmap, (int)n, (int)n, (boolean)true) : Bitmap.createScaledBitmap((Bitmap)this.mIconBitmap, (int)this.mActualWidth, (int)this.mActualWidth, (boolean)true);
    }

    private void updateImageInternal(Bitmap bitmap, String string2, boolean bl) {
        if (bitmap == null) {
            this.showDefaultFavicon();
            return;
        }
        if (this.mUnscaledBitmap == bitmap) {
            return;
        }
        this.mUnscaledBitmap = bitmap;
        this.mIconBitmap = bitmap;
        this.mIconKey = string2;
        this.mScalingExpected = bl;
        this.formatImage();
    }

    public void showDefaultFavicon() {
        this.setImageResource(R.drawable.favicon);
        this.mDominantColor = 0;
    }

    private void showNoImage() {
        this.setImageDrawable(null);
        this.mDominantColor = 0;
    }

    public void clearImage() {
        this.showNoImage();
        this.mUnscaledBitmap = null;
        this.mIconBitmap = null;
        this.mIconKey = null;
        this.mScalingExpected = false;
    }

    public void updateAndScaleImage(Bitmap bitmap, String string2) {
        this.updateImageInternal(bitmap, string2, true);
    }

    public void updateImage(Bitmap bitmap, String string2) {
        this.updateImageInternal(bitmap, string2, false);
    }

    public Bitmap getBitmap() {
        return this.mIconBitmap;
    }

    static {
        sStrokePaint = new Paint(1);
        sStrokePaint.setStyle(Paint.Style.STROKE);
        sBackgroundPaint = new Paint(1);
        sBackgroundPaint.setStyle(Paint.Style.FILL);
    }
}

