/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.NetworkInfo;
import android.net.Uri;
import android.provider.ContactsContract;
import com.squareup.picasso.Action;
import com.squareup.picasso.AssetBitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContactsPhotoBitmapHunter;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.FileBitmapHunter;
import com.squareup.picasso.MediaStoreBitmapHunter;
import com.squareup.picasso.NetworkBitmapHunter;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.ResourceBitmapHunter;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Transformation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

abstract class BitmapHunter
implements Runnable {
    private static final Object DECODE_LOCK = new Object();
    private static final String ANDROID_ASSET = "android_asset";
    protected static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    final Picasso picasso;
    final Dispatcher dispatcher;
    final Cache cache;
    final Stats stats;
    final String key;
    final Request data;
    final List<Action> actions;
    final boolean skipMemoryCache;
    Bitmap result;
    Future<?> future;
    Picasso.LoadedFrom loadedFrom;
    Exception exception;
    int exifRotation;

    BitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        this.picasso = picasso;
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.stats = stats;
        this.key = action.getKey();
        this.data = action.getData();
        this.skipMemoryCache = action.skipCache;
        this.actions = new ArrayList<Action>(4);
        this.attach(action);
    }

    protected void setExifRotation(int n) {
        this.exifRotation = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName("Picasso-" + this.data.getName());
            this.result = this.hunt();
            if (this.result == null) {
                this.dispatcher.dispatchFailed(this);
            } else {
                this.dispatcher.dispatchComplete(this);
            }
        }
        catch (Downloader.ResponseException responseException) {
            this.exception = responseException;
            this.dispatcher.dispatchFailed(this);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            this.dispatcher.dispatchRetry(this);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            StringWriter stringWriter = new StringWriter();
            this.stats.createSnapshot().dump(new PrintWriter(stringWriter));
            this.exception = new RuntimeException(stringWriter.toString(), outOfMemoryError);
            this.dispatcher.dispatchFailed(this);
        }
        catch (Exception exception) {
            this.exception = exception;
            this.dispatcher.dispatchFailed(this);
        }
        finally {
            Thread.currentThread().setName("Picasso-Idle");
        }
    }

    abstract Bitmap decode(Request var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap hunt() throws IOException {
        Bitmap bitmap;
        if (!this.skipMemoryCache && (bitmap = this.cache.get(this.key)) != null) {
            this.stats.dispatchCacheHit();
            this.loadedFrom = Picasso.LoadedFrom.MEMORY;
            return bitmap;
        }
        bitmap = this.decode(this.data);
        if (bitmap != null) {
            this.stats.dispatchBitmapDecoded(bitmap);
            if (this.data.needsTransformation() || this.exifRotation != 0) {
                Object object = DECODE_LOCK;
                synchronized (object) {
                    if (this.data.needsMatrixTransform() || this.exifRotation != 0) {
                        bitmap = BitmapHunter.transformResult(this.data, bitmap, this.exifRotation);
                    }
                    if (this.data.hasCustomTransformations()) {
                        bitmap = BitmapHunter.applyCustomTransformations(this.data.transformations, bitmap);
                    }
                }
                this.stats.dispatchBitmapTransformed(bitmap);
            }
        }
        return bitmap;
    }

    void attach(Action action) {
        this.actions.add(action);
    }

    void detach(Action action) {
        this.actions.remove(action);
    }

    boolean cancel() {
        return this.actions.isEmpty() && this.future != null && this.future.cancel(false);
    }

    boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    boolean shouldSkipMemoryCache() {
        return this.skipMemoryCache;
    }

    boolean shouldRetry(boolean bl, NetworkInfo networkInfo) {
        return false;
    }

    Bitmap getResult() {
        return this.result;
    }

    String getKey() {
        return this.key;
    }

    Request getData() {
        return this.data;
    }

    List<Action> getActions() {
        return this.actions;
    }

    Exception getException() {
        return this.exception;
    }

    Picasso.LoadedFrom getLoadedFrom() {
        return this.loadedFrom;
    }

    static BitmapHunter forRequest(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        if (action.getData().resourceId != 0) {
            return new ResourceBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        Uri uri = action.getData().uri;
        String string = uri.getScheme();
        if ("content".equals(string)) {
            if (ContactsContract.Contacts.CONTENT_URI.getHost().equals(uri.getHost()) && !uri.getPathSegments().contains("photo")) {
                return new ContactsPhotoBitmapHunter(context, picasso, dispatcher, cache, stats, action);
            }
            if ("media".equals(uri.getAuthority())) {
                return new MediaStoreBitmapHunter(context, picasso, dispatcher, cache, stats, action);
            }
            return new ContentStreamBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        if ("file".equals(string)) {
            if (!uri.getPathSegments().isEmpty() && ANDROID_ASSET.equals(uri.getPathSegments().get(0))) {
                return new AssetBitmapHunter(context, picasso, dispatcher, cache, stats, action);
            }
            return new FileBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        if ("android.resource".equals(string)) {
            return new ResourceBitmapHunter(context, picasso, dispatcher, cache, stats, action);
        }
        return new NetworkBitmapHunter(picasso, dispatcher, cache, stats, action, downloader);
    }

    static void calculateInSampleSize(int n, int n2, BitmapFactory.Options options) {
        BitmapHunter.calculateInSampleSize(n, n2, options.outWidth, options.outHeight, options);
    }

    static void calculateInSampleSize(int n, int n2, int n3, int n4, BitmapFactory.Options options) {
        int n5 = 1;
        if (n4 > n2 || n3 > n) {
            int n6;
            int n7 = Math.round((float)n4 / (float)n2);
            n5 = n7 < (n6 = Math.round((float)n3 / (float)n)) ? n7 : n6;
        }
        options.inSampleSize = n5;
        options.inJustDecodeBounds = false;
    }

    static Bitmap applyCustomTransformations(List<Transformation> list, Bitmap bitmap) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            final Transformation transformation = list.get(i);
            Bitmap bitmap2 = transformation.transform(bitmap);
            if (bitmap2 == null) {
                final StringBuilder stringBuilder = new StringBuilder().append("Transformation ").append(transformation.key()).append(" returned null after ").append(i).append(" previous transformation(s).\n\nTransformation list:\n");
                for (Transformation transformation2 : list) {
                    stringBuilder.append(transformation2.key()).append('\n');
                }
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new NullPointerException(stringBuilder.toString());
                    }
                });
                return null;
            }
            if (bitmap2 == bitmap && bitmap.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " returned input Bitmap but recycled it.");
                    }
                });
                return null;
            }
            if (bitmap2 != bitmap && !bitmap.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " mutated input Bitmap but failed to recycle the original.");
                    }
                });
                return null;
            }
            bitmap = bitmap2;
        }
        return bitmap;
    }

    static Bitmap transformResult(Request request, Bitmap bitmap, int n) {
        Bitmap bitmap2;
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int n7 = n3;
        Matrix matrix = new Matrix();
        if (request.needsMatrixTransform()) {
            int n8 = request.targetWidth;
            int n9 = request.targetHeight;
            float f = request.rotationDegrees;
            if (f != 0.0f) {
                if (request.hasRotationPivot) {
                    matrix.setRotate(f, request.rotationPivotX, request.rotationPivotY);
                } else {
                    matrix.setRotate(f);
                }
            }
            if (request.centerCrop) {
                float f2;
                float f3 = (float)n8 / (float)n2;
                float f4 = (float)n9 / (float)n3;
                if (f3 > f4) {
                    f2 = f3;
                    int n10 = (int)Math.ceil((float)n3 * (f4 / f3));
                    n5 = (n3 - n10) / 2;
                    n7 = n10;
                } else {
                    f2 = f4;
                    int n11 = (int)Math.ceil((float)n2 * (f3 / f4));
                    n4 = (n2 - n11) / 2;
                    n6 = n11;
                }
                matrix.preScale(f2, f2);
            } else if (request.centerInside) {
                float f5 = (float)n8 / (float)n2;
                float f6 = (float)n9 / (float)n3;
                float f7 = f5 < f6 ? f5 : f6;
                matrix.preScale(f7, f7);
            } else if (n8 != 0 && n9 != 0 && (n8 != n2 || n9 != n3)) {
                float f8 = (float)n8 / (float)n2;
                float f9 = (float)n9 / (float)n3;
                matrix.preScale(f8, f9);
            }
        }
        if (n != 0) {
            matrix.preRotate((float)n);
        }
        if ((bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n4, (int)n5, (int)n6, (int)n7, (Matrix)matrix, (boolean)true)) != bitmap) {
            bitmap.recycle();
            bitmap = bitmap2;
        }
        return bitmap;
    }
}

