/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.CircularRedirectException;
import ch.boye.httpclientandroidlib.client.RedirectHandler;
import ch.boye.httpclientandroidlib.client.utils.URIUtils;
import ch.boye.httpclientandroidlib.impl.client.RedirectLocations;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.util.Args;
import ch.boye.httpclientandroidlib.util.Asserts;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

@Deprecated
@Immutable
public class DefaultRedirectHandler
implements RedirectHandler {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    @Override
    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        Args.notNull(httpResponse, "HTTP response");
        int n = httpResponse.getStatusLine().getStatusCode();
        switch (n) {
            case 301: 
            case 302: 
            case 307: {
                HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
                String string = httpRequest.getRequestLine().getMethod();
                return string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Serializable serializable;
        Object object;
        Object object2;
        URI uRI;
        Args.notNull(httpResponse, "HTTP response");
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirect requested to location '" + string + "'");
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, uRISyntaxException);
        }
        HttpParams httpParams = httpResponse.getParams();
        if (!uRI.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI + "' not allowed");
            }
            object2 = (HttpHost)httpContext.getAttribute("http.target_host");
            Asserts.notNull(object2, "Target host");
            object = (HttpRequest)httpContext.getAttribute("http.request");
            try {
                serializable = new URI(object.getRequestLine().getUri());
                URI uRI2 = URIUtils.rewriteURI(serializable, (HttpHost)object2, true);
                uRI = URIUtils.resolve(uRI2, uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object2 = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object2 == null) {
                object2 = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object2);
            }
            if (uRI.getFragment() != null) {
                try {
                    serializable = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    object = URIUtils.rewriteURI(uRI, (HttpHost)serializable, true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
                }
            } else {
                object = uRI;
            }
            if (((RedirectLocations)object2).contains((URI)object)) {
                throw new CircularRedirectException("Circular redirect to '" + object + "'");
            }
            ((RedirectLocations)object2).add((URI)object);
        }
        return uRI;
    }
}

