/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.auth.AuthScheme;
import ch.boye.httpclientandroidlib.auth.AuthState;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.client.UserTokenHandler;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.conn.ManagedHttpClientConnection;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext httpContext) {
        SSLSession sSLSession;
        Object object;
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Principal principal = null;
        AuthState authState = httpClientContext.getTargetAuthState();
        if (authState != null && (principal = DefaultUserTokenHandler.getAuthPrincipal(authState)) == null) {
            object = httpClientContext.getProxyAuthState();
            principal = DefaultUserTokenHandler.getAuthPrincipal((AuthState)object);
        }
        if (principal == null && (object = httpClientContext.getConnection()).isOpen() && object instanceof ManagedHttpClientConnection && (sSLSession = ((ManagedHttpClientConnection)object).getSSLSession()) != null) {
            principal = sSLSession.getLocalPrincipal();
        }
        return principal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials credentials;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme != null && authScheme.isComplete() && authScheme.isConnectionBased() && (credentials = authState.getCredentials()) != null) {
            return credentials.getUserPrincipal();
        }
        return null;
    }
}

