/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.cache.Resource;
import ch.boye.httpclientandroidlib.client.cache.ResourceFactory;
import ch.boye.httpclientandroidlib.client.utils.DateUtils;
import ch.boye.httpclientandroidlib.impl.client.cache.HeapResourceFactory;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

@Immutable
class CacheEntryUpdater {
    private final ResourceFactory resourceFactory;

    CacheEntryUpdater() {
        this(new HeapResourceFactory());
    }

    CacheEntryUpdater(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public HttpCacheEntry updateCacheEntry(String string, HttpCacheEntry httpCacheEntry, Date date, Date date2, HttpResponse httpResponse) throws IOException {
        Args.check(httpResponse.getStatusLine().getStatusCode() == 304, "Response must have 304 status code");
        Header[] headerArray = this.mergeHeaders(httpCacheEntry, httpResponse);
        Resource resource = null;
        if (httpCacheEntry.getResource() != null) {
            resource = this.resourceFactory.copy(string, httpCacheEntry.getResource());
        }
        return new HttpCacheEntry(date, date2, httpCacheEntry.getStatusLine(), headerArray, resource);
    }

    protected Header[] mergeHeaders(HttpCacheEntry httpCacheEntry, HttpResponse httpResponse) {
        if (this.entryAndResponseHaveDateHeader(httpCacheEntry, httpResponse) && this.entryDateHeaderNewerThenResponse(httpCacheEntry, httpResponse)) {
            return httpCacheEntry.getAllHeaders();
        }
        ArrayList<Header> arrayList = new ArrayList<Header>(Arrays.asList(httpCacheEntry.getAllHeaders()));
        this.removeCacheHeadersThatMatchResponse(arrayList, httpResponse);
        this.removeCacheEntry1xxWarnings(arrayList, httpCacheEntry);
        arrayList.addAll(Arrays.asList(httpResponse.getAllHeaders()));
        return arrayList.toArray(new Header[arrayList.size()]);
    }

    private void removeCacheHeadersThatMatchResponse(List<Header> list, HttpResponse httpResponse) {
        for (Header header : httpResponse.getAllHeaders()) {
            ListIterator<Header> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = listIterator.next().getName();
                if (!string.equals(header.getName())) continue;
                listIterator.remove();
            }
        }
    }

    private void removeCacheEntry1xxWarnings(List<Header> list, HttpCacheEntry httpCacheEntry) {
        ListIterator<Header> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = listIterator.next().getName();
            if (!"Warning".equals(string)) continue;
            for (Header header : httpCacheEntry.getHeaders("Warning")) {
                if (!header.getValue().startsWith("1")) continue;
                listIterator.remove();
            }
        }
    }

    private boolean entryDateHeaderNewerThenResponse(HttpCacheEntry httpCacheEntry, HttpResponse httpResponse) {
        Date date = DateUtils.parseDate(httpCacheEntry.getFirstHeader("Date").getValue());
        Date date2 = DateUtils.parseDate(httpResponse.getFirstHeader("Date").getValue());
        if (date == null || date2 == null) {
            return false;
        }
        return date.after(date2);
    }

    private boolean entryAndResponseHaveDateHeader(HttpCacheEntry httpCacheEntry, HttpResponse httpResponse) {
        return httpCacheEntry.getFirstHeader("Date") != null && httpResponse.getFirstHeader("Date") != null;
    }
}

