/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.execchain;

import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.auth.AuthScope;
import ch.boye.httpclientandroidlib.auth.UsernamePasswordCredentials;
import ch.boye.httpclientandroidlib.client.CredentialsProvider;
import ch.boye.httpclientandroidlib.client.methods.CloseableHttpResponse;
import ch.boye.httpclientandroidlib.client.methods.HttpExecutionAware;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestWrapper;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.protocol.HttpClientContext;
import ch.boye.httpclientandroidlib.client.utils.URIUtils;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.client.BasicCredentialsProvider;
import ch.boye.httpclientandroidlib.impl.execchain.ClientExecChain;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.protocol.HttpProcessor;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

@Immutable
public class ProtocolExec
implements ClientExecChain {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain clientExecChain, HttpProcessor httpProcessor) {
        Args.notNull(clientExecChain, "HTTP client request executor");
        Args.notNull(httpProcessor, "HTTP protocol processor");
        this.requestExecutor = clientExecChain;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper httpRequestWrapper, HttpRoute httpRoute) throws ProtocolException {
        try {
            URI uRI = httpRequestWrapper.getURI();
            if (uRI != null) {
                if (httpRoute.getProxyHost() != null && !httpRoute.isTunnelled()) {
                    if (!uRI.isAbsolute()) {
                        HttpHost httpHost = httpRoute.getTargetHost();
                        uRI = URIUtils.rewriteURI(uRI, httpHost, true);
                    } else {
                        uRI = URIUtils.rewriteURI(uRI);
                    }
                } else {
                    uRI = uRI.isAbsolute() ? URIUtils.rewriteURI(uRI, null, true) : URIUtils.rewriteURI(uRI);
                }
                httpRequestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + httpRequestWrapper.getRequestLine().getUri(), uRISyntaxException);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Object object;
        Object object2;
        URI uRI;
        block17: {
            Args.notNull(httpRoute, "HTTP route");
            Args.notNull(httpRequestWrapper, "HTTP request");
            Args.notNull(httpClientContext, "HTTP context");
            HttpRequest httpRequest = httpRequestWrapper.getOriginal();
            uRI = null;
            if (httpRequest instanceof HttpUriRequest) {
                uRI = ((HttpUriRequest)httpRequest).getURI();
            } else {
                object2 = httpRequest.getRequestLine().getUri();
                try {
                    uRI = URI.create((String)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this.log.isDebugEnabled()) break block17;
                    this.log.debug("Unable to parse '" + (String)object2 + "' as a valid URI; " + "request URI and Host header may be inconsistent", illegalArgumentException);
                }
            }
        }
        httpRequestWrapper.setURI(uRI);
        this.rewriteRequestURI(httpRequestWrapper, httpRoute);
        object2 = httpRequestWrapper.getParams();
        HttpHost httpHost = (HttpHost)object2.getParameter("http.virtual-host");
        if (httpHost != null && httpHost.getPort() == -1) {
            int n = httpRoute.getTargetHost().getPort();
            if (n != -1) {
                httpHost = new HttpHost(httpHost.getHostName(), n, httpHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using virtual host" + httpHost);
            }
        }
        HttpHost httpHost2 = null;
        if (httpHost != null) {
            httpHost2 = httpHost;
        } else if (uRI != null && uRI.isAbsolute() && uRI.getHost() != null) {
            httpHost2 = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        }
        if (httpHost2 == null) {
            httpHost2 = httpRoute.getTargetHost();
        }
        if (uRI != null && (object = uRI.getUserInfo()) != null) {
            CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
            if (credentialsProvider == null) {
                credentialsProvider = new BasicCredentialsProvider();
                httpClientContext.setCredentialsProvider(credentialsProvider);
            }
            credentialsProvider.setCredentials(new AuthScope(httpHost2), new UsernamePasswordCredentials((String)object));
        }
        httpClientContext.setAttribute("http.target_host", httpHost2);
        httpClientContext.setAttribute("http.route", httpRoute);
        httpClientContext.setAttribute("http.request", httpRequestWrapper);
        this.httpProcessor.process(httpRequestWrapper, (HttpContext)httpClientContext);
        object = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        try {
            httpClientContext.setAttribute("http.response", object);
            this.httpProcessor.process((HttpResponse)object, (HttpContext)httpClientContext);
            return object;
        }
        catch (RuntimeException runtimeException) {
            object.close();
            throw runtimeException;
        }
        catch (IOException iOException) {
            object.close();
            throw iOException;
        }
        catch (HttpException httpException) {
            object.close();
            throw httpException;
        }
    }
}

