/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Bundle;
import java.util.EnumSet;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.util.ThreadUtils;

public class DynamicToolbar {
    private static final String STATE_ENABLED = "dynamic_toolbar";
    private static final String CHROME_PREF = "browser.chrome.dynamictoolbar";
    private volatile boolean prefEnabled;
    private boolean accessibilityEnabled;
    private final int prefObserverId;
    private final EnumSet<PinReason> pinFlags = EnumSet.noneOf(PinReason.class);
    private LayerView layerView;
    private OnEnabledChangedListener enabledChangedListener;

    public DynamicToolbar() {
        this.prefObserverId = PrefsHelper.getPref(CHROME_PREF, new PrefHandler());
    }

    public void destroy() {
        PrefsHelper.removeObserver(this.prefObserverId);
    }

    public void setLayerView(LayerView layerView) {
        ThreadUtils.assertOnUiThread();
        this.layerView = layerView;
    }

    public void setEnabledChangedListener(OnEnabledChangedListener onEnabledChangedListener) {
        ThreadUtils.assertOnUiThread();
        this.enabledChangedListener = onEnabledChangedListener;
    }

    public void onSaveInstanceState(Bundle bundle) {
        ThreadUtils.assertOnUiThread();
        bundle.putBoolean(STATE_ENABLED, this.prefEnabled);
    }

    public void onRestoreInstanceState(Bundle bundle) {
        ThreadUtils.assertOnUiThread();
        if (bundle != null) {
            this.prefEnabled = bundle.getBoolean(STATE_ENABLED);
        }
    }

    public boolean isEnabled() {
        ThreadUtils.assertOnUiThread();
        return this.prefEnabled && !this.accessibilityEnabled;
    }

    public void setAccessibilityEnabled(boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (this.accessibilityEnabled == bl) {
            return;
        }
        this.accessibilityEnabled = bl;
        if (this.prefEnabled) {
            this.triggerEnabledListener();
        }
    }

    public void setVisible(boolean bl, VisibilityTransition visibilityTransition) {
        boolean bl2;
        ThreadUtils.assertOnUiThread();
        if (this.layerView == null) {
            return;
        }
        boolean bl3 = bl2 = visibilityTransition == VisibilityTransition.IMMEDIATE;
        if (bl) {
            this.layerView.getLayerMarginsAnimator().showMargins(bl2);
        } else {
            this.layerView.getLayerMarginsAnimator().hideMargins(bl2);
        }
    }

    public void setPinned(boolean bl, PinReason pinReason) {
        ThreadUtils.assertOnUiThread();
        if (this.layerView == null) {
            return;
        }
        if (bl) {
            this.pinFlags.add(pinReason);
        } else {
            this.pinFlags.remove((Object)pinReason);
        }
        this.layerView.getLayerMarginsAnimator().setMarginsPinned(!this.pinFlags.isEmpty());
    }

    private void triggerEnabledListener() {
        if (this.enabledChangedListener != null) {
            this.enabledChangedListener.onEnabledChanged(this.isEnabled());
        }
    }

    private class PrefHandler
    extends PrefsHelper.PrefHandlerBase {
        private PrefHandler() {
        }

        @Override
        public void prefValue(String string2, boolean bl) {
            if (bl == DynamicToolbar.this.prefEnabled) {
                return;
            }
            DynamicToolbar.this.prefEnabled = bl;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!DynamicToolbar.this.accessibilityEnabled) {
                        DynamicToolbar.this.triggerEnabledListener();
                    }
                }
            });
        }

        @Override
        public boolean isObserver() {
            return true;
        }
    }

    public static interface OnEnabledChangedListener {
        public void onEnabledChanged(boolean var1);
    }

    public static enum VisibilityTransition {
        IMMEDIATE,
        ANIMATE;

    }

    public static enum PinReason {
        RELAYOUT,
        ACTION_MODE;

    }
}

