/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import java.util.List;
import org.mozilla.gecko.AppConstants;

public final class InputMethods {
    public static final String METHOD_ANDROID_LATINIME = "com.android.inputmethod.latin/.LatinIME";
    public static final String METHOD_ATOK = "com.justsystems.atokmobile.service/.AtokInputMethodService";
    public static final String METHOD_GOOGLE_JAPANESE_INPUT = "com.google.android.inputmethod.japanese/.MozcService";
    public static final String METHOD_GOOGLE_LATINIME = "com.google.android.inputmethod.latin/com.android.inputmethod.latin.LatinIME";
    public static final String METHOD_HTC_TOUCH_INPUT = "com.htc.android.htcime/.HTCIMEService";
    public static final String METHOD_IWNN = "jp.co.omronsoft.iwnnime.ml/.standardcommon.IWnnLanguageSwitcher";
    public static final String METHOD_OPENWNN_PLUS = "com.owplus.ime.openwnnplus/.OpenWnnJAJP";
    public static final String METHOD_SAMSUNG = "com.sec.android.inputmethod/.SamsungKeypad";
    public static final String METHOD_SIMEJI = "com.adamrocker.android.input.simeji/.OpenWnnSimeji";
    public static final String METHOD_SWIFTKEY = "com.touchtype.swiftkey/com.touchtype.KeyboardService";
    public static final String METHOD_SWYPE = "com.swype.android.inputmethod/.SwypeInputMethod";
    public static final String METHOD_SWYPE_BETA = "com.nuance.swype.input/.IME";
    public static final String METHOD_TOUCHPAL_KEYBOARD = "com.cootek.smartinputv5/com.cootek.smartinput5.TouchPalIME";

    private InputMethods() {
    }

    public static String getCurrentInputMethod(Context context) {
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"default_input_method");
        return string2 != null ? string2 : "";
    }

    public static InputMethodInfo getInputMethodInfo(Context context, String string2) {
        InputMethodManager inputMethodManager = InputMethods.getInputMethodManager(context);
        List list = inputMethodManager.getEnabledInputMethodList();
        for (InputMethodInfo inputMethodInfo : list) {
            if (!inputMethodInfo.getId().equals(string2)) continue;
            return inputMethodInfo;
        }
        return null;
    }

    public static InputMethodManager getInputMethodManager(Context context) {
        return (InputMethodManager)context.getSystemService("input_method");
    }

    public static boolean needsSoftResetWorkaround(String string2) {
        return AppConstants.Versions.feature17Plus && (METHOD_ANDROID_LATINIME.equals(string2) || METHOD_GOOGLE_LATINIME.equals(string2));
    }

    public static boolean shouldCommitCharAsKey(String string2) {
        return METHOD_HTC_TOUCH_INPUT.equals(string2);
    }

    public static boolean isGestureKeyboard(Context context) {
        String string2 = InputMethods.getCurrentInputMethod(context);
        return AppConstants.Versions.feature17Plus && (METHOD_ANDROID_LATINIME.equals(string2) || METHOD_GOOGLE_LATINIME.equals(string2)) || METHOD_SWYPE.equals(string2) || METHOD_SWYPE_BETA.equals(string2) || METHOD_TOUCHPAL_KEYBOARD.equals(string2);
    }
}

