/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.upload;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.background.bagheera.BagheeraClient;
import org.mozilla.gecko.background.bagheera.BagheeraRequestDelegate;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.AndroidConfigurationProvider;
import org.mozilla.gecko.background.healthreport.Environment;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportGenerator;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;
import org.mozilla.gecko.background.healthreport.ProfileInformationCache;
import org.mozilla.gecko.background.healthreport.upload.SubmissionClient;
import org.mozilla.gecko.sync.net.BaseResource;

public class AndroidSubmissionClient
implements SubmissionClient {
    protected static final String LOG_TAG = AndroidSubmissionClient.class.getSimpleName();
    private static final String MEASUREMENT_NAME_SUBMISSIONS = "org.mozilla.healthreport.submissions";
    private static final int MEASUREMENT_VERSION_SUBMISSIONS = 1;
    protected final Context context;
    protected final SharedPreferences sharedPreferences;
    protected final String profilePath;
    protected final EnvironmentBuilder.ConfigurationProvider config;

    public AndroidSubmissionClient(Context context, SharedPreferences sharedPreferences, String string2) {
        this(context, sharedPreferences, string2, new AndroidConfigurationProvider(context));
    }

    public AndroidSubmissionClient(Context context, SharedPreferences sharedPreferences, String string2, EnvironmentBuilder.ConfigurationProvider configurationProvider) {
        this.context = context;
        this.sharedPreferences = sharedPreferences;
        this.profilePath = string2;
        this.config = configurationProvider;
    }

    public SharedPreferences getSharedPreferences() {
        return this.sharedPreferences;
    }

    public String getDocumentServerURI() {
        return this.getSharedPreferences().getString("healthreport_document_server_uri", "https://fhr.data.mozilla.com/");
    }

    public String getDocumentServerNamespace() {
        return this.getSharedPreferences().getString("healthreport_document_server_namespace", "metrics");
    }

    public long getLastUploadLocalTime() {
        return this.getSharedPreferences().getLong("healthreport_last_upload_local_time", 0L);
    }

    public String getLastUploadDocumentId() {
        return this.getSharedPreferences().getString("healthreport_last_upload_document_id", null);
    }

    public boolean hasUploadBeenRequested() {
        return this.getSharedPreferences().contains("healthreport_last_upload_requested");
    }

    public void setLastUploadLocalTimeAndDocumentId(long l, String string2) {
        this.getSharedPreferences().edit().putLong("healthreport_last_upload_local_time", l).putString("healthreport_last_upload_document_id", string2).commit();
    }

    protected HealthReportDatabaseStorage getStorage(ContentProviderClient contentProviderClient) {
        return EnvironmentBuilder.getStorage(contentProviderClient, this.profilePath);
    }

    protected JSONObject generateDocument(long l, long l2, SubmissionsTracker submissionsTracker) throws JSONException {
        long l3 = l - 15552000000L;
        SubmissionsTracker.TrackingGenerator trackingGenerator = submissionsTracker.getGenerator();
        return ((HealthReportGenerator)trackingGenerator).generateDocument(l3, l2, this.profilePath, this.config);
    }

    protected void uploadPayload(String string2, String string3, Collection<String> collection, BagheeraRequestDelegate bagheeraRequestDelegate) {
        BagheeraClient bagheeraClient = new BagheeraClient(this.getDocumentServerURI());
        Logger.pii(LOG_TAG, "New health report has id " + string2 + "and obsoletes " + (collection != null ? Integer.toString(collection.size()) : "no") + " old ids.");
        try {
            bagheeraClient.uploadJSONDocument(this.getDocumentServerNamespace(), string2, string3, collection, bagheeraRequestDelegate);
        }
        catch (Exception exception) {
            bagheeraRequestDelegate.handleError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(long l, String string2, Collection<String> collection, SubmissionClient.Delegate delegate) {
        ContentProviderClient contentProviderClient = EnvironmentBuilder.getContentProviderClient(this.context);
        if (contentProviderClient == null) {
            delegate.onHardFailure(l, null, "Could not fetch content provider client.", null);
            return;
        }
        try {
            JSONObject jSONObject;
            SubmissionsTracker submissionsTracker;
            block14: {
                HealthReportDatabaseStorage healthReportDatabaseStorage = this.getStorage(contentProviderClient);
                if (healthReportDatabaseStorage == null) {
                    delegate.onHardFailure(l, null, "No storage when generating report.", null);
                    return;
                }
                long l2 = Math.max(this.getLastUploadLocalTime(), 1367500000000L);
                if (!healthReportDatabaseStorage.hasEventSince(l2)) {
                    delegate.onHardFailure(l, null, "No new events in storage.", null);
                    return;
                }
                this.initializeStorageForUploadProviders(healthReportDatabaseStorage);
                submissionsTracker = this.getSubmissionsTracker(healthReportDatabaseStorage, l, this.hasUploadBeenRequested());
                try {
                    jSONObject = this.generateDocument(l, l2, submissionsTracker);
                    if (jSONObject != null) break block14;
                    delegate.onHardFailure(l, null, "Generator returned null document.", null);
                    return;
                }
                catch (Exception exception) {
                    submissionsTracker.incrementUploadClientFailureCount();
                    throw exception;
                }
            }
            SubmissionsTracker.TrackingRequestDelegate trackingRequestDelegate = submissionsTracker.getDelegate(delegate, l, true, string2);
            this.uploadPayload(string2, jSONObject.toString(), collection, trackingRequestDelegate);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception generating document.", exception);
            delegate.onHardFailure(l, null, "Got exception uploading.", exception);
            return;
        }
        finally {
            contentProviderClient.release();
        }
    }

    protected SubmissionsTracker getSubmissionsTracker(HealthReportStorage healthReportStorage, long l, boolean bl) {
        return new SubmissionsTracker(healthReportStorage, l, bl);
    }

    @Override
    public void delete(long l, String string2, SubmissionClient.Delegate delegate) {
        BagheeraClient bagheeraClient = new BagheeraClient(this.getDocumentServerURI());
        Logger.pii(LOG_TAG, "Deleting health report with id " + string2 + ".");
        RequestDelegate requestDelegate = new RequestDelegate(delegate, l, false, string2);
        try {
            bagheeraClient.deleteDocument(this.getDocumentServerNamespace(), string2, requestDelegate);
        }
        catch (Exception exception) {
            requestDelegate.handleError(exception);
        }
    }

    private void initializeStorageForUploadProviders(HealthReportDatabaseStorage healthReportDatabaseStorage) {
        healthReportDatabaseStorage.beginInitialization();
        try {
            this.initializeSubmissionsProvider(healthReportDatabaseStorage);
            healthReportDatabaseStorage.finishInitialization();
        }
        catch (Exception exception) {
            healthReportDatabaseStorage.abortInitialization();
            throw new IllegalStateException("Could not initialize storage for upload provider.", exception);
        }
    }

    private void initializeSubmissionsProvider(HealthReportDatabaseStorage healthReportDatabaseStorage) {
        healthReportDatabaseStorage.ensureMeasurementInitialized(MEASUREMENT_NAME_SUBMISSIONS, 1, new HealthReportStorage.MeasurementFields(){

            @Override
            public Iterable<HealthReportStorage.MeasurementFields.FieldSpec> getFields() {
                ArrayList<HealthReportStorage.MeasurementFields.FieldSpec> arrayList = new ArrayList<HealthReportStorage.MeasurementFields.FieldSpec>();
                for (SubmissionsFieldName submissionsFieldName : SubmissionsFieldName.values()) {
                    HealthReportStorage.MeasurementFields.FieldSpec fieldSpec = new HealthReportStorage.MeasurementFields.FieldSpec(submissionsFieldName.getName(), 1025);
                    arrayList.add(fieldSpec);
                }
                return arrayList;
            }
        });
    }

    public class SubmissionsTracker {
        private final HealthReportStorage storage;
        private final ProfileInformationCache profileCache;
        private final int day;
        private final int envID;
        private boolean isUploadStatusCountIncremented;

        public SubmissionsTracker(HealthReportStorage healthReportStorage, long l, boolean bl) throws IllegalStateException {
            this.storage = healthReportStorage;
            this.profileCache = this.getProfileInformationCache();
            this.day = healthReportStorage.getDay(l);
            this.envID = this.registerCurrentEnvironment();
            this.isUploadStatusCountIncremented = false;
            if (!bl) {
                this.incrementFirstUploadAttemptCount();
            } else {
                this.incrementContinuationAttemptCount();
            }
        }

        protected ProfileInformationCache getProfileInformationCache() {
            ProfileInformationCache profileInformationCache = new ProfileInformationCache(AndroidSubmissionClient.this.profilePath);
            if (!profileInformationCache.restoreUnlessInitialized()) {
                Logger.warn(LOG_TAG, "Not enough profile information to compute current environment.");
                throw new IllegalStateException("Could not retrieve current environment.");
            }
            return profileInformationCache;
        }

        protected int registerCurrentEnvironment() {
            return EnvironmentBuilder.registerCurrentEnvironment(this.storage, this.profileCache, AndroidSubmissionClient.this.config);
        }

        protected void incrementFirstUploadAttemptCount() {
            Logger.debug(LOG_TAG, "Incrementing first upload attempt field.");
            this.storage.incrementDailyCount(this.envID, this.day, SubmissionsFieldName.FIRST_ATTEMPT.getID(this.storage));
        }

        protected void incrementContinuationAttemptCount() {
            Logger.debug(LOG_TAG, "Incrementing continuation upload attempt field.");
            this.storage.incrementDailyCount(this.envID, this.day, SubmissionsFieldName.CONTINUATION_ATTEMPT.getID(this.storage));
        }

        public void incrementUploadSuccessCount() {
            this.incrementStatusCount(SubmissionsFieldName.SUCCESS.getID(this.storage), "success");
        }

        public void incrementUploadClientFailureCount() {
            this.incrementStatusCount(SubmissionsFieldName.CLIENT_FAILURE.getID(this.storage), "client failure");
        }

        public void incrementUploadTransportFailureCount() {
            this.incrementStatusCount(SubmissionsFieldName.TRANSPORT_FAILURE.getID(this.storage), "transport failure");
        }

        public void incrementUploadServerFailureCount() {
            this.incrementStatusCount(SubmissionsFieldName.SERVER_FAILURE.getID(this.storage), "server failure");
        }

        private void incrementStatusCount(int n, String string2) {
            if (!this.isUploadStatusCountIncremented) {
                Logger.debug(LOG_TAG, "Incrementing upload attempt " + string2 + " count.");
                this.storage.incrementDailyCount(this.envID, this.day, n);
                this.isUploadStatusCountIncremented = true;
            } else {
                Logger.warn(LOG_TAG, "Upload status count already incremented - not incrementing " + string2 + " count.");
            }
        }

        public TrackingGenerator getGenerator() {
            return new TrackingGenerator();
        }

        public TrackingRequestDelegate getDelegate(SubmissionClient.Delegate delegate, long l, boolean bl, String string2) {
            return new TrackingRequestDelegate(delegate, l, bl, string2);
        }

        public class TrackingRequestDelegate
        extends RequestDelegate {
            public TrackingRequestDelegate(SubmissionClient.Delegate delegate, long l, boolean bl, String string2) {
                super(delegate, l, bl, string2);
            }

            @Override
            public void handleSuccess(int n, String string2, String string3, HttpResponse httpResponse) {
                super.handleSuccess(n, string2, string3, httpResponse);
                SubmissionsTracker.this.incrementUploadSuccessCount();
            }

            @Override
            public void handleFailure(int n, String string2, HttpResponse httpResponse) {
                super.handleFailure(n, string2, httpResponse);
                SubmissionsTracker.this.incrementUploadServerFailureCount();
            }

            @Override
            public void handleError(Exception exception) {
                super.handleError(exception);
                if (exception instanceof IllegalArgumentException || exception instanceof UnsupportedEncodingException || exception instanceof URISyntaxException) {
                    SubmissionsTracker.this.incrementUploadClientFailureCount();
                } else {
                    SubmissionsTracker.this.incrementUploadTransportFailureCount();
                }
            }
        }

        public class TrackingGenerator
        extends HealthReportGenerator {
            public TrackingGenerator() {
                super(SubmissionsTracker.this.storage);
            }

            @Override
            public JSONObject generateDocument(long l, long l2, String string2, EnvironmentBuilder.ConfigurationProvider configurationProvider) throws JSONException {
                JSONObject jSONObject;
                BrowserLocaleManager.getInstance().getAndApplyPersistedLocale(AndroidSubmissionClient.this.context);
                if (AndroidSubmissionClient.this.profilePath != null && AndroidSubmissionClient.this.profilePath.equals(string2)) {
                    Environment environment = this.getCurrentEnvironment();
                    jSONObject = super.generateDocument(l, l2, environment);
                } else {
                    jSONObject = super.generateDocument(l, l2, string2, configurationProvider);
                }
                if (jSONObject == null) {
                    SubmissionsTracker.this.incrementUploadClientFailureCount();
                }
                return jSONObject;
            }

            protected Environment getCurrentEnvironment() {
                return EnvironmentBuilder.getCurrentEnvironment(SubmissionsTracker.this.profileCache, AndroidSubmissionClient.this.config);
            }
        }
    }

    public static enum SubmissionsFieldName {
        FIRST_ATTEMPT("firstDocumentUploadAttempt"),
        CONTINUATION_ATTEMPT("continuationDocumentUploadAttempt"),
        SUCCESS("uploadSuccess"),
        TRANSPORT_FAILURE("uploadTransportFailure"),
        SERVER_FAILURE("uploadServerFailure"),
        CLIENT_FAILURE("uploadClientFailure");

        private final String name;

        private SubmissionsFieldName(String string3) {
            this.name = string3;
        }

        public String getName() {
            return this.name;
        }

        public int getID(HealthReportStorage healthReportStorage) {
            HealthReportStorage.Field field = healthReportStorage.getField(AndroidSubmissionClient.MEASUREMENT_NAME_SUBMISSIONS, 1, this.name);
            return field.getID();
        }
    }

    protected class RequestDelegate
    implements BagheeraRequestDelegate {
        protected final SubmissionClient.Delegate delegate;
        protected final boolean isUpload;
        protected final String methodString;
        protected final long localTime;
        protected final String id;

        public RequestDelegate(SubmissionClient.Delegate delegate, long l, boolean bl, String string2) {
            this.delegate = delegate;
            this.localTime = l;
            this.isUpload = bl;
            this.methodString = this.isUpload ? "upload" : "delete";
            this.id = string2;
        }

        @Override
        public String getUserAgent() {
            return "Firefox-Android-HealthReport/36.0a1 (Nightly)";
        }

        @Override
        public void handleSuccess(int n, String string2, String string3, HttpResponse httpResponse) {
            BaseResource.consumeEntity(httpResponse);
            if (this.isUpload) {
                AndroidSubmissionClient.this.setLastUploadLocalTimeAndDocumentId(this.localTime, string3);
            }
            Logger.debug(LOG_TAG, "Successful " + this.methodString + " at " + this.localTime + ".");
            this.delegate.onSuccess(this.localTime, string3);
        }

        @Override
        public void handleFailure(int n, String string2, HttpResponse httpResponse) {
            BaseResource.consumeEntity(httpResponse);
            Logger.debug(LOG_TAG, "Failed " + this.methodString + " at " + this.localTime + ".");
            if (n >= 500) {
                this.delegate.onSoftFailure(this.localTime, this.id, "Got status " + n + " from server.", null);
                return;
            }
            this.delegate.onHardFailure(this.localTime, this.id, "Got status " + n + " from server.", null);
        }

        @Override
        public void handleError(Exception exception) {
            Logger.debug(LOG_TAG, "Exception during " + this.methodString + " at " + this.localTime + ".", exception);
            if (exception instanceof IOException) {
                this.delegate.onSoftFailure(this.localTime, this.id, "Got exception during " + this.methodString + ".", exception);
                return;
            }
            this.delegate.onHardFailure(this.localTime, this.id, "Got exception during " + this.methodString + ".", exception);
        }
    }
}

