/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.preferences;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.gecko.background.preferences.PreferenceFragment;

public class PreferenceManagerCompat {
    private static final String TAG = PreferenceManagerCompat.class.getSimpleName();

    static PreferenceManager newInstance(Activity activity, int n) {
        try {
            Constructor constructor = PreferenceManager.class.getDeclaredConstructor(Activity.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (PreferenceManager)constructor.newInstance(activity, n);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call constructor PreferenceManager by reflection", (Throwable)exception);
            return null;
        }
    }

    static void setFragment(PreferenceManager preferenceManager, PreferenceFragment preferenceFragment) {
    }

    static void setOnPreferenceTreeClickListener(PreferenceManager preferenceManager, final OnPreferenceTreeClickListener onPreferenceTreeClickListener) {
        try {
            Field field = PreferenceManager.class.getDeclaredField("mOnPreferenceTreeClickListener");
            field.setAccessible(true);
            if (onPreferenceTreeClickListener != null) {
                Object object = Proxy.newProxyInstance(field.getType().getClassLoader(), new Class[]{field.getType()}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object object, Method method, Object[] objectArray) {
                        if (method.getName().equals("onPreferenceTreeClick")) {
                            return onPreferenceTreeClickListener.onPreferenceTreeClick((PreferenceScreen)objectArray[0], (Preference)objectArray[1]);
                        }
                        return null;
                    }
                });
                field.set(preferenceManager, object);
            } else {
                field.set(preferenceManager, null);
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't set PreferenceManager.mOnPreferenceTreeClickListener by reflection", (Throwable)exception);
        }
    }

    static PreferenceScreen inflateFromIntent(PreferenceManager preferenceManager, Intent intent, PreferenceScreen preferenceScreen) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("inflateFromIntent", Intent.class, PreferenceScreen.class);
            method.setAccessible(true);
            PreferenceScreen preferenceScreen2 = (PreferenceScreen)method.invoke((Object)preferenceManager, intent, preferenceScreen);
            return preferenceScreen2;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.inflateFromIntent by reflection", (Throwable)exception);
            return null;
        }
    }

    static PreferenceScreen inflateFromResource(PreferenceManager preferenceManager, Activity activity, int n, PreferenceScreen preferenceScreen) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("inflateFromResource", Context.class, Integer.TYPE, PreferenceScreen.class);
            method.setAccessible(true);
            PreferenceScreen preferenceScreen2 = (PreferenceScreen)method.invoke((Object)preferenceManager, activity, n, preferenceScreen);
            return preferenceScreen2;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.inflateFromResource by reflection", (Throwable)exception);
            return null;
        }
    }

    static PreferenceScreen getPreferenceScreen(PreferenceManager preferenceManager) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("getPreferenceScreen", new Class[0]);
            method.setAccessible(true);
            return (PreferenceScreen)method.invoke((Object)preferenceManager, new Object[0]);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.getPreferenceScreen by reflection", (Throwable)exception);
            return null;
        }
    }

    static void dispatchActivityResult(PreferenceManager preferenceManager, int n, int n2, Intent intent) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("dispatchActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
            method.setAccessible(true);
            method.invoke((Object)preferenceManager, n, n2, intent);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.dispatchActivityResult by reflection", (Throwable)exception);
        }
    }

    static void dispatchActivityStop(PreferenceManager preferenceManager) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("dispatchActivityStop", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)preferenceManager, new Object[0]);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.dispatchActivityStop by reflection", (Throwable)exception);
        }
    }

    static void dispatchActivityDestroy(PreferenceManager preferenceManager) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("dispatchActivityDestroy", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)preferenceManager, new Object[0]);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.dispatchActivityDestroy by reflection", (Throwable)exception);
        }
    }

    static boolean setPreferences(PreferenceManager preferenceManager, PreferenceScreen preferenceScreen) {
        try {
            Method method = PreferenceManager.class.getDeclaredMethod("setPreferences", PreferenceScreen.class);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)preferenceManager, preferenceScreen);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Couldn't call PreferenceManager.setPreferences by reflection", (Throwable)exception);
            return false;
        }
    }

    static interface OnPreferenceTreeClickListener {
        public boolean onPreferenceTreeClick(PreferenceScreen var1, Preference var2);
    }
}

