/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa;

import android.accounts.Account;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.support.v4.content.AsyncTaskLoader;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.sync.setup.SyncAccounts;

public class AccountLoader
extends AsyncTaskLoader<Account> {
    protected Account account = null;
    protected BroadcastReceiver broadcastReceiver = null;

    public AccountLoader(Context context) {
        super(context);
    }

    public Account loadInBackground() {
        Account[] accountArray;
        Context context = this.getContext();
        Account account = FirefoxAccounts.getFirefoxAccount(context);
        if (account == null && (accountArray = SyncAccounts.syncAccounts(context)) != null && accountArray.length > 0) {
            account = accountArray[0];
        }
        return account;
    }

    public void deliverResult(Account account) {
        if (this.isReset()) {
            this.releaseResources(account);
            return;
        }
        Account account2 = this.account;
        this.account = account;
        if (this.isStarted()) {
            super.deliverResult((Object)account);
        }
        if (account2 != null && account2 != account) {
            this.releaseResources(account2);
        }
    }

    protected void onStartLoading() {
        if (this.account != null) {
            this.deliverResult(this.account);
        }
        if (this.broadcastReceiver == null) {
            this.broadcastReceiver = this.makeNewObserver();
            this.registerObserver(this.broadcastReceiver);
        }
        if (this.takeContentChanged() || this.account == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.stopLoading();
        if (this.account != null) {
            this.releaseResources(this.account);
            this.account = null;
        }
        if (this.broadcastReceiver != null) {
            BroadcastReceiver broadcastReceiver = this.broadcastReceiver;
            this.broadcastReceiver = null;
            this.unregisterObserver(broadcastReceiver);
        }
    }

    public void onCanceled(Account account) {
        super.onCanceled((Object)account);
        this.releaseResources(account);
    }

    private void releaseResources(Account account) {
    }

    protected BroadcastReceiver makeNewObserver() {
        BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                AccountLoader.this.onContentChanged();
            }
        };
        return broadcastReceiver;
    }

    protected void registerObserver(BroadcastReceiver broadcastReceiver) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.accounts.LOGIN_ACCOUNTS_CHANGED");
        intentFilter.addAction("org.mozilla.fennec_fxaccount.accounts.ACCOUNT_STATE_CHANGED_ACTION");
        Handler handler = null;
        this.getContext().registerReceiver(broadcastReceiver, intentFilter, "org.mozilla.fennec_fxaccount.permission.PER_ACCOUNT_TYPE", handler);
    }

    protected void unregisterObserver(BroadcastReceiver broadcastReceiver) {
        this.getContext().unregisterReceiver(broadcastReceiver);
    }
}

